/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.preferences;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionsWithSelection;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.view.items.EditableItemsPanel;
import name.schedenig.eclipse.grepconsole.view.styles.StylesPanel;
import name.schedenig.eclipse.grepconsole.view.whatsnew.WhatsNewDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class GrepConsolePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TabFolder tabFolder;
    private TabItem tiExpressions;
    private TabItem tiStyles;
    private EditableItemsPanel panelExpressions;
    private StylesPanel panelStyles;

    protected Control createContents(Composite parent) {
        Activator activator = Activator.getDefault();
        GrepExpressionsWithSelection expressions = new GrepExpressionsWithSelection(activator.getExpressions().copy(true), null, null, null, null);
        this.tabFolder = new TabFolder(parent, 128);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tiExpressions = new TabItem(this.tabFolder, 0);
        this.tiExpressions.setText(Messages.GrepConsolePreferencePage_expressions);
        this.panelExpressions = this.createExpressionsPanel((Composite)this.tabFolder);
        this.tiExpressions.setControl((Control)this.panelExpressions);
        this.panelExpressions.setExpressions(expressions);
        this.tiStyles = new TabItem(this.tabFolder, 0);
        this.tiStyles.setText(Messages.GrepConsolePreferencePage_styles);
        this.panelStyles = this.createStylesPanel((Composite)this.tabFolder);
        this.tiStyles.setControl((Control)this.panelStyles);
        this.panelStyles.setRoot(expressions.getRootFolder());
        return this.tabFolder;
    }

    protected Point doComputeSize() {
        return GrepConsoleUtil.charsToPixelDimensions((Drawable)this.getShell(), 40, 25);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.panelExpressions.resizeColumns();
        WhatsNewDialog.showIfEnabled(parent.getShell());
    }

    private EditableItemsPanel createExpressionsPanel(Composite parent) {
        EditableItemsPanel panel = new EditableItemsPanel(parent, 0);
        panel.setLayoutData(new GridData(4, 4, true, true));
        return panel;
    }

    private StylesPanel createStylesPanel(Composite parent) {
        StylesPanel panel = new StylesPanel(parent, 0);
        panel.setLayoutData(new GridData(4, 4, true, true));
        return panel;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        Activator activator = Activator.getDefault();
        GrepExpressionRootFolder activatorExpressions = activator.getExpressions();
        activatorExpressions.copyFrom(this.panelExpressions.getExpressions().getRootFolder(), true);
        try {
            activator.saveSettings();
        }
        catch (ParserConfigurationException ex) {
            Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
        }
        catch (TransformerException ex) {
            Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
        }
        catch (BackingStoreException ex) {
            Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        GrepExpressionRootFolder expressions = Activator.getDefault().loadDefaults().copy(true);
        this.panelExpressions.setExpressions(new GrepExpressionsWithSelection(expressions, null, null, null, null));
        this.panelStyles.setRoot(expressions);
        super.performDefaults();
    }
}

