/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GridLayoutBuilder {
    private GridLayout layout;
    private FontMetrics fontMetrics;
    private Composite control;

    private static FontMetrics getFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        try {
            gc.setFont(control.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            return fontMetrics;
        }
        finally {
            gc.dispose();
        }
    }

    public GridLayoutBuilder(Composite control, int numColumns, boolean makeColumnsEqualWidth) {
        this(control, GridLayoutBuilder.getFontMetrics((Control)control));
        this.setNumColumns(numColumns);
        this.setMakeColumnsEqualWidth(makeColumnsEqualWidth);
    }

    public GridLayoutBuilder(Composite control) {
        this(control, GridLayoutBuilder.getFontMetrics((Control)control));
    }

    public GridLayoutBuilder(FontMetrics fontMetrics) {
        this(null, fontMetrics);
    }

    public GridLayoutBuilder(Composite control, FontMetrics fontMetrics) {
        this.control = control;
        this.fontMetrics = fontMetrics;
        this.init();
    }

    private void init() {
        this.layout = new GridLayout();
        if (this.fontMetrics != null) {
            this.layout.marginHeight = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fontMetrics, (int)7);
            this.layout.marginWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)7);
            this.layout.verticalSpacing = Dialog.convertVerticalDLUsToPixels((FontMetrics)this.fontMetrics, (int)4);
            this.layout.horizontalSpacing = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)4);
        }
        this.layout.marginLeft = this.layout.marginRight = this.layout.marginWidth;
        this.layout.marginTop = this.layout.marginBottom = this.layout.marginHeight;
        this.layout.marginHeight = 0;
        this.layout.marginWidth = 0;
    }

    public GridLayout getLayout() {
        return this.layout;
    }

    public void apply() {
        this.control.setLayout((Layout)this.layout);
    }

    public GridLayoutBuilder setNumColumns(int numColumns) {
        this.layout.numColumns = numColumns;
        return this;
    }

    public GridLayoutBuilder setMakeColumnsEqualWidth(boolean makeColumnsEqualWidth) {
        this.layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        return this;
    }

    public GridLayoutBuilder setMarginHeight(int marginHeight) {
        this.layout.marginTop = this.layout.marginBottom = marginHeight;
        return this;
    }

    public GridLayoutBuilder setMarginWidth(int marginWidth) {
        this.layout.marginLeft = this.layout.marginRight = marginWidth;
        return this;
    }

    public GridLayoutBuilder setMarginLeft(int marginLeft) {
        this.layout.marginLeft = marginLeft;
        return this;
    }

    public GridLayoutBuilder setMarginTop(int marginTop) {
        this.layout.marginTop = marginTop;
        return this;
    }

    public GridLayoutBuilder setMarginRight(int marginRight) {
        this.layout.marginRight = marginRight;
        return this;
    }

    public GridLayoutBuilder setMarginBottom(int marginBottom) {
        this.layout.marginBottom = marginBottom;
        return this;
    }

    public GridLayoutBuilder setHorizontalSpacing(int horizontalSpacing) {
        this.layout.horizontalSpacing = horizontalSpacing;
        return this;
    }

    public GridLayoutBuilder setVerticalSpacing(int verticalSpacing) {
        this.layout.verticalSpacing = verticalSpacing;
        return this;
    }

    public GridLayoutBuilder setMargins(int margins) {
        return this.setMarginWidth(margins).setMarginHeight(margins);
    }
}

