/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.common;

import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.actions.LinkedToConsoleAction;
import name.schedenig.eclipse.grepconsole.actions.SelectConsoleAction;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GrepConsoleView
extends ViewPart
implements Activator.IGrepConsoleListener,
GrepPageParticipant.IGrepPageParticipantListener,
IPropertyChangeListener {
    private static final String KEY_LINK_TO_CONSOLE = "linkToConsole";
    private IConsole console;
    private boolean linkedToConsole = true;
    private LinkedToConsoleAction linkedToConsoleAction;
    private SelectConsoleAction selectConsoleAction;
    private GrepPageParticipant participant;

    public GrepConsoleView() {
        Activator.getDefault().addListener(this);
    }

    public void dispose() {
        Activator activator = Activator.getDefault();
        if (this.participant != null) {
            this.participant.removeListener(this);
        }
        activator.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        activator.removeListener(this);
        ScopedPreferenceStore debugUiPrefs = GrepConsoleUtil.getDebugUiPreferences();
        if (debugUiPrefs != null) {
            debugUiPrefs.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.dispose();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IToolBarManager toolbar = site.getActionBars().getToolBarManager();
        this.linkedToConsoleAction = new LinkedToConsoleAction(this);
        toolbar.add((IAction)this.linkedToConsoleAction);
        this.selectConsoleAction = new SelectConsoleAction(this);
        toolbar.add((IAction)this.selectConsoleAction);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.linkedToConsole = this.getMementoBoolean(memento, KEY_LINK_TO_CONSOLE, this.linkedToConsole);
        this.linkedToConsoleAction.setChecked(this.linkedToConsole);
    }

    protected boolean getMementoBoolean(IMemento memento, String key, boolean defaultValue) {
        if (memento == null) {
            return defaultValue;
        }
        Boolean b = memento.getBoolean(key);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    @Override
    public void participantAdded(GrepPageParticipant participant) {
    }

    @Override
    public void participantRemoved(GrepPageParticipant participant) {
        if (this.participant == participant) {
            this.setConsole(null);
        }
    }

    @Override
    public void participantActivated(GrepPageParticipant participant) {
        if (this.linkedToConsole || this.console == null) {
            if (participant == null) {
                this.setConsole(null);
            } else {
                this.setConsole(participant.getConsole());
            }
        }
    }

    public void setConsole(IConsole console) {
        this.console = console;
        this.setParticipant(console == null ? null : Activator.getDefault().getParticipant(console));
    }

    protected void setParticipant(GrepPageParticipant participant) {
        this.participant = participant;
    }

    public IConsole getConsole() {
        return this.console;
    }

    public void setLinkedToConsole(boolean linkedToConsole) {
        this.linkedToConsole = linkedToConsole;
    }

    public boolean isLinkedToConsole() {
        return this.linkedToConsole;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putBoolean(KEY_LINK_TO_CONSOLE, this.linkedToConsole);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void participantChanged(GrepPageParticipant grepPageParticipant) {
    }

    @Override
    public void settingsChanged() {
    }

    public void createPartControl(Composite parent) {
    }

    public void setFocus() {
    }

    public GrepPageParticipant getParticipant() {
        return this.participant;
    }
}

