/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FolderDialog
extends InputDialog {
    private GrepExpressionFolder folder;
    private Button cbActiveByDefault;
    private Button cbFilterDefault;
    private Button cbNotificationsDefault;
    private Button cbStatisticsDefault;

    public FolderDialog(Shell parentShell, GrepExpressionFolder folder, boolean add) {
        super(parentShell, add ? Messages.FolderDialog_title_add_folder : Messages.FolderDialog_title_edit_folder, Messages.FolderDialog_name, "", new IInputValidator(){

            public String isValid(String newText) {
                return newText.trim().length() == 0 ? Messages.FolderDialog_please_enter_a_name : null;
            }
        });
        this.setFolder(folder);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        Dialog.applyDialogFont((Control)parent);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.cbActiveByDefault = new Button(composite, 32);
        this.cbActiveByDefault.setText(Messages.FolderDialog_active_by_default);
        this.cbActiveByDefault.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.cbFilterDefault = new Button(composite, 32);
        this.cbFilterDefault.setText(Messages.FolderDialog_filter_by_default);
        this.cbFilterDefault.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.cbStatisticsDefault = new Button(composite, 32);
        this.cbStatisticsDefault.setText(Messages.FolderDialog_statistics_by_default);
        this.cbStatisticsDefault.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.cbNotificationsDefault = new Button(composite, 32);
        this.cbNotificationsDefault.setText(Messages.FolderDialog_notifications_active_by_default);
        this.cbNotificationsDefault.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.refresh();
    }

    private void refresh() {
        String name = this.folder.getName();
        this.getText().setText(name == null ? "" : name);
        this.getText().selectAll();
        this.cbActiveByDefault.setSelection(this.folder.isDefaultEnabled());
        this.cbFilterDefault.setSelection(this.folder.isDefaultFilter());
        this.cbStatisticsDefault.setSelection(this.folder.isDefaultStatistics());
        this.cbNotificationsDefault.setSelection(this.folder.isDefaultNotifications());
    }

    public void setFolder(GrepExpressionFolder folder) {
        this.folder = folder;
    }

    protected void okPressed() {
        this.folder.setName(this.getValue().trim());
        this.folder.setDefaultEnabled(this.cbActiveByDefault.getSelection());
        this.folder.setDefaultFilter(this.cbFilterDefault.getSelection());
        this.folder.setDefaultStatistics(this.cbStatisticsDefault.getSelection());
        this.folder.setDefaultNotifications(this.cbNotificationsDefault.getSelection());
        super.okPressed();
    }
}

