/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import java.text.MessageFormat;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionsWithSelection;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.view.DefaultSizeTitleAreaDialog;
import name.schedenig.eclipse.grepconsole.view.items.EditableItemsPanel;
import name.schedenig.eclipse.grepconsole.view.styles.StylesPanel;
import name.schedenig.eclipse.grepconsole.view.whatsnew.WhatsNewDialog;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class ItemsAndStylesDialog
extends DefaultSizeTitleAreaDialog {
    public static final String DIALOG_SETTINGS_SECTION = "itemsDialog";
    public static final String DIALOG_SETTINGS_SASH_POSITION = "sashPosition";
    private GrepExpressionsWithSelection expressions;
    private String previewText;
    private ILaunchConfiguration launchConfig;
    private EditableItemsPanel panelExpressions;
    private TabFolder tabFolder;
    private TabItem tiExpressions;
    private TabItem tiStyles;
    private StylesPanel panelStyles;

    public ItemsAndStylesDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.panelExpressions.setExpressions(this.expressions);
        this.panelExpressions.setPreviewText(this.previewText);
        this.panelStyles.setRoot(this.expressions.getRootFolder());
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ItemsAndStylesDialog_title_manage_expressions);
        newShell.addShellListener((ShellListener)new WhatsNewDialog.ShellListener());
    }

    @Override
    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "name.schedenig.eclipse.grepconsole.manage_expressions");
        Control content = super.createContents(parent);
        this.setTitle(Messages.ItemsAndStylesDialog_title_manage_expressions);
        this.setTitleImage(Activator.getDefault().getImageRegistry().get("logo_large"));
        this.updateMessage();
        return content;
    }

    protected Control createDialogArea(Composite parent) {
        Dialog.applyDialogFont((Control)parent);
        this.setHelpAvailable(true);
        this.tabFolder = new TabFolder(parent, 128);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tiExpressions = new TabItem(this.tabFolder, 0);
        this.tiExpressions.setText(Messages.ItemsAndStylesDialog_expressions);
        this.panelExpressions = this.createItemsPanel(this.tabFolder);
        this.tiExpressions.setControl((Control)this.panelExpressions);
        this.tiStyles = new TabItem(this.tabFolder, 0);
        this.tiStyles.setText(Messages.ItemsAndStylesDialog_styles);
        this.panelStyles = this.createStylesPanel(this.tabFolder);
        this.tiStyles.setControl((Control)this.panelStyles);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ItemsAndStylesDialog.this.tabFolder.getSelection()[0] == ItemsAndStylesDialog.this.tiExpressions) {
                    ItemsAndStylesDialog.this.panelExpressions.refresh();
                } else {
                    ItemsAndStylesDialog.this.panelStyles.refresh();
                }
            }
        });
        return this.tabFolder;
    }

    private EditableItemsPanel createItemsPanel(TabFolder parent) {
        EditableItemsPanel panel = new EditableItemsPanel((Composite)parent, 0);
        return panel;
    }

    private StylesPanel createStylesPanel(TabFolder parent) {
        StylesPanel panel = new StylesPanel((Composite)parent, 0);
        return panel;
    }

    public void setExpressions(GrepExpressionsWithSelection expressions) {
        this.expressions = expressions;
    }

    public GrepExpressionsWithSelection getExpressions() {
        return this.expressions;
    }

    public EditableItemsPanel getItemsPanel() {
        return this.panelExpressions;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_SECTION);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return settings;
    }

    public boolean close() {
        Integer sashPosition = this.panelExpressions.getSashPosition();
        if (sashPosition != null) {
            this.getDialogBoundsSettings().put(DIALOG_SETTINGS_SASH_POSITION, sashPosition.intValue());
        }
        return super.close();
    }

    @Override
    protected Point getDefaultSize() {
        return GrepConsoleUtil.charsToPixelDimensions((Drawable)this.getShell(), 90, 35);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        shell.setMinimumSize(GrepConsoleUtil.charsToPixelDimensions((Drawable)shell, 60, 28));
        IDialogSettings settings = this.getDialogBoundsSettings();
        if (settings.get(DIALOG_SETTINGS_SASH_POSITION) != null) {
            this.panelExpressions.setSashPosition(settings.getInt(DIALOG_SETTINGS_SASH_POSITION));
        }
    }

    public void setPreviewText(String text) {
        this.previewText = text;
        if (this.panelExpressions != null) {
            this.panelExpressions.setPreviewText(text);
        }
    }

    public String getPreviewText() {
        return this.previewText;
    }

    public void setLaunchConfiguration(ILaunchConfiguration launchConfig) {
        this.launchConfig = launchConfig;
        if (this.panelExpressions != null) {
            this.updateMessage();
        }
    }

    public void updateMessage() {
        if (this.launchConfig == null) {
            this.setMessage(Messages.ItemsAndStylesDialog_check_boxes_global, 1);
        } else {
            this.setMessage(MessageFormat.format(Messages.ItemsAndStylesDialog_check_boxes_launch_config, this.launchConfig.getName()), 1);
        }
    }
}

