/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class StyleImageRegistry {
    private Map<RgbPair, Image> colorImages = new HashMap<RgbPair, Image>();

    public void dispose() {
        for (Image image : this.colorImages.values()) {
            image.dispose();
        }
        this.colorImages.clear();
    }

    public Image getColorImage(RgbPair color) {
        Image image = this.colorImages.get(color);
        if (image == null) {
            image = this.createColorImage(color);
            this.colorImages.put(color, image);
        }
        return image;
    }

    private Image createColorImage(RgbPair color) {
        int height = 16;
        int width = (int)((double)height * 1.5);
        RGB black = new RGB(0, 0, 0);
        RGB left = color.getRgb1() == null ? new RGB(255, 255, 255) : color.getRgb1();
        RGB right = color.getRgb2() == null ? new RGB(255, 255, 255) : color.getRgb2();
        PaletteData dataPalette = new PaletteData(new RGB[]{black, left, right});
        ImageData data = new ImageData(width, height, 2, dataPalette);
        data.transparentPixel = -1;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                if (x == 0 || y == 0 || x == width - 1 || y == height - 1) {
                    data.setPixel(x, y, 0);
                } else {
                    data.setPixel(x, y, x < width / 2 ? 1 : 2);
                }
                ++x;
            }
            ++y;
        }
        return new Image(null, data);
    }

    public static class RgbPair {
        private RGB rgb1;
        private RGB rgb2;

        public RgbPair(RGB rgb1, RGB rgb2) {
            this.rgb1 = rgb1;
            this.rgb2 = rgb2;
        }

        public RGB getRgb1() {
            return this.rgb1;
        }

        public RGB getRgb2() {
            return this.rgb2;
        }

        public int hashCode() {
            return (this.rgb1 == null ? 0 : this.rgb1.hashCode()) | (this.rgb2 == null ? 0 : this.rgb2.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RgbPair)) {
                return false;
            }
            RgbPair pair = (RgbPair)obj;
            if (this.rgb1 == null || pair.rgb1 == null ? this.rgb1 != pair.rgb1 : !this.rgb1.equals((Object)pair.rgb1)) {
                return false;
            }
            return !(this.rgb2 == null || pair.rgb2 == null ? this.rgb2 != pair.rgb2 : !this.rgb2.equals((Object)pair.rgb2));
        }
    }
}

