/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items.links;

import java.util.HashMap;
import java.util.Map;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.links.CommandLink;
import name.schedenig.eclipse.grepconsole.model.links.FileLink;
import name.schedenig.eclipse.grepconsole.model.links.IGrepLink;
import name.schedenig.eclipse.grepconsole.model.links.JavaLink;
import name.schedenig.eclipse.grepconsole.model.links.ScriptLink;
import name.schedenig.eclipse.grepconsole.model.links.UrlLink;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.util.GridLayoutBuilder;
import name.schedenig.eclipse.grepconsole.view.DefaultSizeDialog;
import name.schedenig.eclipse.grepconsole.view.items.links.CommandLinkPanel;
import name.schedenig.eclipse.grepconsole.view.items.links.FileLinkPanel;
import name.schedenig.eclipse.grepconsole.view.items.links.JavaLinkPanel;
import name.schedenig.eclipse.grepconsole.view.items.links.LinkPanel;
import name.schedenig.eclipse.grepconsole.view.items.links.ScriptLinkPanel;
import name.schedenig.eclipse.grepconsole.view.items.links.UrlLinkPanel;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LinkDialog
extends DefaultSizeDialog {
    public static final String DIALOG_SETTINGS_SECTION = "linkDialog";
    public static final Map<Class<? extends IGrepLink>, String> TYPE_NAMES = new HashMap<Class<? extends IGrepLink>, String>();
    private IGrepLink link;
    private Map<Class<? extends IGrepLink>, IGrepLink> cachedLinks = new HashMap<Class<? extends IGrepLink>, IGrepLink>();
    private Map<Class<? extends IGrepLink>, LinkPanel> panels = new HashMap<Class<? extends IGrepLink>, LinkPanel>();
    private boolean withCaptureGroup;
    private Label labelType;
    private Combo comboType;
    private ComboViewer viewerType;
    private UrlLinkPanel panelUrl;
    private ScriptLinkPanel panelScript;
    private Composite panelLinkSpecific;
    private FileLinkPanel panelFile;
    private JavaLinkPanel panelJava;
    private CommandLinkPanel panelCommand;

    static {
        TYPE_NAMES.put(NoLink.class, Messages.LinkDialog_no_link);
        TYPE_NAMES.put(FileLink.class, Messages.LinkDialog_link_file);
        TYPE_NAMES.put(JavaLink.class, Messages.LinkDialog_link_java_type);
        TYPE_NAMES.put(UrlLink.class, Messages.LinkDialog_link_url);
        TYPE_NAMES.put(ScriptLink.class, Messages.LinkDialog_link_script);
        TYPE_NAMES.put(CommandLink.class, Messages.LinkDialog_link_command);
    }

    public LinkDialog(Shell parentShell, boolean withCaptureGroup) {
        super(parentShell);
        this.withCaptureGroup = withCaptureGroup;
        this.cachedLinks.put(NoLink.class, null);
        this.cachedLinks.put(FileLink.class, new FileLink());
        this.cachedLinks.put(JavaLink.class, new JavaLink());
        this.cachedLinks.put(UrlLink.class, new UrlLink());
        this.cachedLinks.put(ScriptLink.class, new ScriptLink());
        this.cachedLinks.put(CommandLink.class, new CommandLink());
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_SECTION);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return settings;
    }

    @Override
    protected Point getDefaultSize() {
        Shell shell = this.getShell();
        return GrepConsoleUtil.charsToPixelDimensions((Drawable)shell, 60, 15);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        shell.setMinimumSize(GrepConsoleUtil.charsToPixelDimensions((Drawable)shell, 60, 18));
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LinkDialog_edit_link);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "name.schedenig.eclipse.grepconsole.edit_link");
        Composite composite = new Composite(parent, 0);
        new GridLayoutBuilder(composite, 2, false).apply();
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.labelType = new Label(composite, 0);
        this.labelType.setText(Messages.LinkDialog_type);
        this.labelType.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.comboType = new Combo(composite, 8);
        this.comboType.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.viewerType = new ComboViewer(this.comboType);
        this.viewerType.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String name = TYPE_NAMES.get(element);
                return name == null ? String.valueOf(element) : name;
            }
        });
        this.viewerType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Class type = (Class)((IStructuredSelection)event.getSelection()).getFirstElement();
                LinkDialog.this.typeChanged(type);
            }
        });
        this.viewerType.setInput((Object)new Class[]{NoLink.class, FileLink.class, JavaLink.class, UrlLink.class, CommandLink.class, ScriptLink.class});
        this.panelLinkSpecific = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.verticalIndent = 10;
        this.panelLinkSpecific.setLayoutData((Object)gridData);
        StackLayout linkSpecificLayout = new StackLayout();
        linkSpecificLayout.marginHeight = 0;
        linkSpecificLayout.marginWidth = 0;
        this.panelLinkSpecific.setLayout((Layout)linkSpecificLayout);
        this.panelFile = new FileLinkPanel(this.panelLinkSpecific, this.withCaptureGroup);
        this.panels.put(FileLink.class, this.panelFile);
        this.panelJava = new JavaLinkPanel(this.panelLinkSpecific, this.withCaptureGroup);
        this.panels.put(JavaLink.class, this.panelJava);
        this.panelUrl = new UrlLinkPanel(this.panelLinkSpecific, this.withCaptureGroup);
        this.panels.put(UrlLink.class, this.panelUrl);
        this.panelCommand = new CommandLinkPanel(this.panelLinkSpecific, this.withCaptureGroup);
        this.panels.put(CommandLink.class, this.panelCommand);
        this.panelScript = new ScriptLinkPanel(this.panelLinkSpecific, this.withCaptureGroup);
        this.panels.put(ScriptLink.class, this.panelScript);
        this.refreshContent(true);
        return composite;
    }

    protected void typeChanged(Class<? extends IGrepLink> type) {
        this.link = this.cachedLinks.get(type);
        this.refreshContent(false);
    }

    public void setLink(IGrepLink link) {
        IGrepLink iGrepLink = this.link = link == null ? null : link.copy();
        if (this.link != null) {
            this.cachedLinks.put(this.link.getClass(), this.link);
        }
        if (this.viewerType != null) {
            this.refreshContent(true);
        }
    }

    private void refreshContent(boolean refreshCombo) {
        if (refreshCombo) {
            this.viewerType.setSelection((ISelection)new StructuredSelection(this.link == null ? NoLink.class : this.link.getClass()));
        }
        if (this.link != null) {
            LinkPanel panel = this.panels.get(this.link.getClass());
            panel.setLink(this.link);
            ((StackLayout)this.panelLinkSpecific.getLayout()).topControl = panel;
            this.panelLinkSpecific.layout();
            this.panelLinkSpecific.setVisible(true);
        } else {
            this.panelLinkSpecific.setVisible(false);
        }
    }

    public IGrepLink getLink() {
        return this.link;
    }

    public static abstract class NoLink
    implements IGrepLink {
    }
}

