/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.notifications;

import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.popupnotifications.INotificationStyle;
import name.schedenig.eclipse.popupnotifications.IPopupNotificationManagerListener;
import name.schedenig.eclipse.popupnotifications.PopupNotificationManager;
import name.schedenig.eclipse.popupnotifications.ResourceManagingNotificationStyle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class GrepConsoleNotificationStyle
extends ResourceManagingNotificationStyle
implements Activator.IGrepConsoleListener,
IPopupNotificationManagerListener {
    private Activator activator;
    private PopupNotificationManager manager;

    public GrepConsoleNotificationStyle(INotificationStyle parent, Activator activator, PopupNotificationManager manager) {
        super(parent);
        this.activator = activator;
        this.manager = manager;
        activator.addListener(this);
        manager.addListener((IPopupNotificationManagerListener)this);
        this.refresh();
    }

    public void dispose() {
        this.manager.removeListener((IPopupNotificationManagerListener)this);
        this.activator.removeListener(this);
        super.dispose();
    }

    public void refresh() {
        Display display = this.manager.getDisplay();
        RGB rgb = GrepConsoleUtil.getNotificationForegroundColor();
        if (rgb != null) {
            this.setForeground(new Color((Device)display, rgb), true);
        } else {
            this.setForeground(null, false);
        }
        rgb = GrepConsoleUtil.getNotificationBackgroundColor();
        if (rgb != null) {
            this.setBackground(new Color((Device)display, rgb), true);
        } else {
            this.setBackground(null, false);
        }
        IPreferenceStore prefs = this.activator.getPreferenceStore();
        if (prefs.getString("notificationTitleFont").length() == 0) {
            this.setTitleFont(JFaceResources.getBannerFont(), false);
        } else {
            Font titleFont = new Font((Device)display, PreferenceConverter.getFontData((IPreferenceStore)prefs, (String)"notificationTitleFont"));
            this.setTitleFont(titleFont, true);
        }
        if (prefs.getString("notificationMessageFont").length() == 0) {
            this.setMessageFont(JFaceResources.getDialogFont(), false);
        } else {
            Font messageFont = new Font((Device)display, PreferenceConverter.getFontData((IPreferenceStore)prefs, (String)"notificationMessageFont"));
            this.setMessageFont(messageFont, true);
        }
    }

    @Override
    public void participantAdded(GrepPageParticipant participant) {
    }

    @Override
    public void participantRemoved(GrepPageParticipant participant) {
    }

    @Override
    public void participantActivated(GrepPageParticipant participant) {
    }

    @Override
    public void settingsChanged() {
        this.manager.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!GrepConsoleNotificationStyle.this.manager.isDisposed()) {
                    GrepConsoleNotificationStyle.this.refresh();
                }
            }
        });
    }

    public void disposed(PopupNotificationManager manager) {
        this.dispose();
    }
}

