/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.declaration;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.declaration.LSBasedHyperlink;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class OpenDeclarationHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        URI uri;
        IDocument document;
        block7: {
            document = textViewer.getDocument();
            try {
                uri = LSPEclipseUtils.toUri(document);
                if (uri != null) break block7;
                return null;
            }
            catch (BadLocationException e1) {
                LanguageServerPlugin.logError(e1);
                return null;
            }
        }
        TextDocumentPositionParams params = new TextDocumentPositionParams(new TextDocumentIdentifier(uri.toString()), LSPEclipseUtils.toPosition(region.getOffset(), document));
        IRegion r = this.findWord(textViewer.getDocument(), region.getOffset());
        IRegion linkRegion = r != null ? r : region;
        List allLinks = Collections.synchronizedList(new ArrayList());
        try {
            Collection allFutures = Collections.synchronizedCollection(new ArrayList());
            ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{LanguageServiceAccessor.getLanguageServers(textViewer.getDocument(), capabilities -> Boolean.TRUE.equals(capabilities.getDefinitionProvider())).thenAcceptAsync(languageServers -> languageServers.stream().map(ls -> ls.getTextDocumentService().definition(LSPEclipseUtils.toDefinitionParams(params))).forEach(allFutures::add)), LanguageServiceAccessor.getLanguageServers(textViewer.getDocument(), OpenDeclarationHyperlinkDetector::isTypeDefinitionProvider).thenAcceptAsync(languageServers -> languageServers.stream().map(ls -> ls.getTextDocumentService().typeDefinition(LSPEclipseUtils.toTypeDefinitionParams(params))).forEach(allFutures::add))}).thenCompose(theVoid -> CompletableFuture.allOf((CompletableFuture[])allFutures.stream().map(future -> future.thenAccept(locations -> {
                Collection<LSBasedHyperlink> links = OpenDeclarationHyperlinkDetector.toHyperlinks(document, linkRegion, (Either<List<? extends Location>, List<? extends LocationLink>>)locations);
                Collection collection2 = allLinks;
                synchronized (collection2) {
                    allLinks.addAll(links);
                }
            })).toArray(CompletableFuture[]::new)))).get(500L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        if (allLinks.isEmpty()) {
            return null;
        }
        return allLinks.toArray(new IHyperlink[allLinks.size()]);
    }

    private static Collection<LSBasedHyperlink> toHyperlinks(IDocument document, IRegion linkRegion, Either<List<? extends Location>, List<? extends LocationLink>> locations) {
        if (locations == null) {
            return Collections.emptyList();
        }
        if (locations.isLeft()) {
            return ((List)locations.getLeft()).stream().filter(Objects::nonNull).map(location -> new LSBasedHyperlink((Location)location, linkRegion)).collect(Collectors.toList());
        }
        if (locations.isRight()) {
            return ((List)locations.getRight()).stream().filter(Objects::nonNull).map(locationLink -> {
                IRegion selectionRegion = linkRegion;
                Range originSelectionRange = locationLink.getOriginSelectionRange();
                if (originSelectionRange != null) {
                    try {
                        int offset = LSPEclipseUtils.toOffset(originSelectionRange.getStart(), document);
                        int endOffset = LSPEclipseUtils.toOffset(originSelectionRange.getEnd(), document);
                        selectionRegion = new Region(offset, endOffset - offset);
                    }
                    catch (BadLocationException e) {
                        LanguageServerPlugin.logError(e.getMessage(), e);
                    }
                }
                return new LSBasedHyperlink((LocationLink)locationLink, selectionRegion);
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static boolean isTypeDefinitionProvider(ServerCapabilities capabilities) {
        Either typeDefinitionProvider = capabilities.getTypeDefinitionProvider();
        if (typeDefinitionProvider == null) {
            return false;
        }
        if (typeDefinitionProvider.isLeft()) {
            return Boolean.TRUE.equals(typeDefinitionProvider.getLeft());
        }
        return typeDefinitionProvider.isRight();
    }

    private IRegion findWord(IDocument document, int offset) {
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0 && pos < document.getLength()) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isUnicodeIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException x) {
            LanguageServerPlugin.logWarning(x.getMessage(), x);
        }
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

