/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications;

import name.schedenig.eclipse.popupnotifications.PopupNotificationManager;
import name.schedenig.eclipse.popupnotifications.PreferenceBackedNotificationStyle;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IPropertyChangeListener,
PreferenceBackedNotificationStyle.IPreferenceStoreProvider {
    public static final String PLUGIN_ID = "name.schedenig.popupnotifications";
    public static final String PREFS_PREFIX = "popupNotifications.";
    public static final String PREFS_FOREGROUND_COLOR = "popupNotifications.foregroundColor";
    public static final String PREFS_BACKGROUND_COLOR = "popupNotifications.backgroundColor";
    public static final String PREFS_TITLE_FONT = "popupNotifications.titleFont";
    public static final String PREFS_MESSAGE_FONT = "popupNotifications.messageFont";
    private static Activator plugin;
    private PopupNotificationManager popupNotificationManager;
    private PreferenceBackedNotificationStyle defaultStyle;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.popupNotificationManager != null) {
            this.popupNotificationManager.dispose();
            this.popupNotificationManager = null;
        }
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public synchronized PopupNotificationManager getManager() {
        if (this.popupNotificationManager == null) {
            Display display = this.getWorkbench().getDisplay();
            this.popupNotificationManager = new PopupNotificationManager(display);
            this.defaultStyle = new PreferenceBackedNotificationStyle(this.popupNotificationManager.getDefaultNotificationStyle(), this.popupNotificationManager, this);
            this.popupNotificationManager.setDefaultNotificationStyle(this.defaultStyle);
        }
        return this.popupNotificationManager;
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if ((PREFS_BACKGROUND_COLOR.equals(prop) || PREFS_FOREGROUND_COLOR.equals(prop) || PREFS_TITLE_FONT.equals(prop) || PREFS_MESSAGE_FONT.equals(prop)) && this.defaultStyle != null) {
            this.defaultStyle.refresh();
        }
    }
}

