/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications;

import name.schedenig.eclipse.popupnotifications.Animation;
import org.eclipse.swt.widgets.Shell;

public class FadeAnimation
extends Animation {
    private Shell shell;
    private int alphaFrom;
    private int alphaTo;

    public FadeAnimation(Shell shell, int duration, int step, int alphaFrom, int alphaTo) {
        super(shell.getDisplay(), duration, step);
        this.shell = shell;
        this.alphaFrom = alphaFrom;
        this.alphaTo = alphaTo;
    }

    @Override
    protected boolean update(long time) {
        if (this.shell.isDisposed()) {
            return false;
        }
        if (time < (long)this.getDuration()) {
            float progress = (float)time / (float)this.getDuration();
            float alphaDelta = this.alphaTo - this.alphaFrom;
            int alpha = (int)((float)this.alphaFrom + alphaDelta * progress);
            this.shell.setAlpha(alpha);
            if (alpha > 0) {
                this.shell.setVisible(true);
            }
        } else {
            this.shell.setAlpha(this.alphaTo);
        }
        return super.update(time);
    }
}

