/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications;

import name.schedenig.eclipse.popupnotifications.INotificationStyle;
import name.schedenig.eclipse.popupnotifications.IPopupNotificationManagerListener;
import name.schedenig.eclipse.popupnotifications.PopupNotificationManager;
import name.schedenig.eclipse.popupnotifications.ResourceManagingNotificationStyle;
import name.schedenig.eclipse.popupnotifications.utils.PopupNotificationsUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PreferenceBackedNotificationStyle
extends ResourceManagingNotificationStyle
implements IPopupNotificationManagerListener {
    private PopupNotificationManager manager;
    private IPreferenceStoreProvider preferenceStoreProvider;

    public PreferenceBackedNotificationStyle(INotificationStyle parent, PopupNotificationManager manager, IPreferenceStoreProvider preferenceStoreProvider) {
        super(parent);
        this.manager = manager;
        this.preferenceStoreProvider = preferenceStoreProvider;
        manager.addListener(this);
        this.refresh();
    }

    @Override
    public void dispose() {
        this.manager.removeListener(this);
        super.dispose();
    }

    public void refresh() {
        Display display = this.manager.getDisplay();
        IPreferenceStore prefs = this.preferenceStoreProvider.getPreferenceStore();
        RGB rgb = PopupNotificationsUtil.getPreferenceRgb(prefs, "popupNotifications.foregroundColor");
        if (rgb != null) {
            this.setForeground(new Color((Device)display, rgb), true);
        } else {
            this.setForeground(null, false);
        }
        rgb = PopupNotificationsUtil.getPreferenceRgb(prefs, "popupNotifications.backgroundColor");
        if (rgb != null) {
            this.setBackground(new Color((Device)display, rgb), true);
        } else {
            this.setBackground(null, false);
        }
        if (prefs.getString("popupNotifications.titleFont").length() == 0) {
            this.setTitleFont(JFaceResources.getBannerFont(), false);
        } else {
            Font titleFont = new Font((Device)display, PreferenceConverter.getFontData((IPreferenceStore)prefs, (String)"popupNotifications.titleFont"));
            this.setTitleFont(titleFont, true);
        }
        if (prefs.getString("popupNotifications.messageFont").length() == 0) {
            this.setMessageFont(JFaceResources.getDialogFont(), false);
        } else {
            Font messageFont = new Font((Device)display, PreferenceConverter.getFontData((IPreferenceStore)prefs, (String)"popupNotifications.messageFont"));
            this.setMessageFont(messageFont, true);
        }
    }

    @Override
    public void disposed(PopupNotificationManager manager) {
        this.dispose();
    }

    public static interface IPreferenceStoreProvider {
        public IPreferenceStore getPreferenceStore();
    }
}

