/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.popupnotifications.utils;

import java.util.Random;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.RGB;

public class PopupNotificationsUtil {
    private static Random random = new Random();

    public static String intHexString(int value, int length) {
        String hex = Integer.toHexString(value);
        if (hex.length() < length) {
            StringBuffer sb = new StringBuffer("0");
            int i = sb.length() + hex.length();
            while (i < length) {
                sb.append('0');
                ++i;
            }
            sb.append(hex);
            hex = sb.toString();
        }
        return hex;
    }

    public static RGB getRandomRgb() {
        return new RGB(128 + random.nextInt(128), 128 + random.nextInt(128), 128 + random.nextInt(128));
    }

    public static String rgbToString(RGB color) {
        if (color == null) {
            return "";
        }
        return String.valueOf(PopupNotificationsUtil.intHexString(color.red, 2)) + PopupNotificationsUtil.intHexString(color.green, 2) + PopupNotificationsUtil.intHexString(color.blue, 2);
    }

    public static RGB stringToRgb(String s) throws NumberFormatException {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.length() != 6) {
            s = "000000" + s;
            s = s.substring(s.length() - 6);
        }
        return new RGB(Integer.parseInt(s.substring(0, 2), 16), Integer.parseInt(s.substring(2, 4), 16), Integer.parseInt(s.substring(4, 6), 16));
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static RGB getPreferenceRgb(IPreferenceStore prefs, String pref) {
        String s = prefs.getString(pref);
        if (s == null || s.length() == 0) {
            return null;
        }
        return PopupNotificationsUtil.stringToRgb(s);
    }
}

