/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.editor;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.sweetlemonade.eclipse.json.JsonPlugin;
import org.sweetlemonade.eclipse.json.editor.JsonAnnotationer;
import org.sweetlemonade.eclipse.json.editor.JsonConfiguration;
import org.sweetlemonade.eclipse.json.editor.StringInput;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.model.JsonObject;
import org.sweetlemonade.eclipse.json.model.antlr.ParseUtils;
import org.sweetlemonade.eclipse.json.outline.JsonOutlinePage;
import org.sweetlemonade.eclipse.json.outline.JsonQuickOutline;
import org.sweetlemonade.eclipse.json.preference.JsonPreferencesInitializer;

public class JsonEditor
extends TextEditor {
    private JsonOutlinePage mOutlinePage;
    private JsonElement mElement;
    private JsonAnnotationer mAnnotationer;
    private boolean mDirty;
    private final IdentityHashMap<IMarker, Annotation> mProblems = new IdentityHashMap();

    public JsonEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new JsonConfiguration(this));
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)new DefaultCharacterPairMatcher(new char[]{'{', '}', '[', ']'}));
        support.setMatchingCharacterPainterPreferenceKeys("colorMatchBracketEnabled", "colorMatchBracket");
        super.configureSourceViewerDecorationSupport(support);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.sweetlemonade.eclipse.json.jsonEditorScope"});
    }

    private void format() {
        this.mDirty = this.isDirty();
        this.mAnnotationer.store();
        ((ProjectionViewer)this.getSourceViewer()).doOperation(15);
    }

    protected void createActions() {
        super.createActions();
        Action action = new Action(){

            public void run() {
                JsonEditor.this.format();
            }
        };
        action.setActionDefinitionId("org.sweetlemonade.eclipse.json.format");
        action.setText("Format Json");
        this.setAction("org.sweetlemonade.eclipse.json.format", (IAction)action);
        action = new Action(){

            public void run() {
                if (JsonEditor.this.mElement != null) {
                    JsonQuickOutline outline = new JsonQuickOutline(JsonEditor.this.getSite().getShell(), JsonEditor.this);
                    outline.setInput(JsonEditor.this.mElement);
                    outline.setVisible(true);
                    outline.setFocus();
                }
            }
        };
        action.setActionDefinitionId("org.sweetlemonade.eclipse.json.outline");
        action.setText("Quick outline");
        this.setAction("org.sweetlemonade.eclipse.json.outline", (IAction)action);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (JsonPlugin.getDefault().getPreferenceStore().getBoolean("saveAsOnSave") && this.getEditorInput() instanceof StringInput) {
            this.doSaveAs();
        } else {
            super.doSave(progressMonitor);
            if (JsonPlugin.getDefault().getPreferenceStore().getBoolean("autoFormatOnSave")) {
                this.format();
            }
        }
    }

    public void doSaveAfterFormat() {
        if (!this.mDirty) {
            super.doSave(this.getProgressMonitor());
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "org.sweetlemonade.eclipse.json.format");
        this.addAction(menu, "group.open", "org.sweetlemonade.eclipse.json.outline");
    }

    public IPreferenceStore getMergedPreferenceStore() {
        return this.getPreferenceStore();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore store = this.getPreferenceStore();
        IPreferenceStore myStore = JsonPlugin.getDefault().getPreferenceStore();
        if (store != null) {
            this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{store, myStore}));
        } else {
            this.setPreferenceStore(myStore);
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        JsonPreferencesInitializer.TokenType[] values = JsonPreferencesInitializer.TokenType.values();
        String property = event.getProperty();
        JsonPreferencesInitializer.TokenType[] tokenTypeArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            JsonPreferencesInitializer.TokenType colorType = tokenTypeArray[n2];
            if (colorType.getKey().equals(property) || colorType.getEnabledKey().equals(property) || colorType.getStyleKey().equals(property)) {
                this.updatePresentation();
                break;
            }
            ++n2;
        }
        int i = 0;
        while (i < JsonPreferencesInitializer.FORMAT_KEYS.length) {
            String key = JsonPreferencesInitializer.FORMAT_KEYS[i];
            if (key.equals(property)) {
                this.updatePresentation();
                break;
            }
            ++i;
        }
    }

    private void updatePresentation() {
        ((JsonConfiguration)this.getSourceViewerConfiguration()).updatePreferences();
        this.getSourceViewer().invalidateTextPresentation();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        SourceViewerDecorationSupport support = this.getSourceViewerDecorationSupport(this.getSourceViewer());
        support.install(this.getPreferenceStore());
        ProjectionViewer sourceViewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projectionSupport = new ProjectionSupport(sourceViewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.install();
        sourceViewer.doOperation(19);
        this.mAnnotationer = new JsonAnnotationer(sourceViewer.getProjectionAnnotationModel(), this, this.getSourceViewer());
    }

    public IDocumentProvider getDocumentProvider() {
        IDocumentProvider provider = super.getDocumentProvider();
        if (provider == null) {
            return provider;
        }
        if (provider.getAnnotationModel((Object)this.getEditorInput()) == null) {
            return new ForwardingDocumentProvider(null, new IDocumentSetupParticipant(){

                public void setup(IDocument document) {
                }
            }, provider){

                public IAnnotationModel getAnnotationModel(Object element) {
                    return new AnnotationModel();
                }
            };
        }
        return provider;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public Object getAdapter(Class required) {
        if (IContentOutlinePage.class.equals((Object)required)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(required);
    }

    private void findDupKeys(JsonElement element, IResource resource, boolean hasResource) {
        block7: {
            block6: {
                if (element == null) {
                    return;
                }
                if (!element.isObject()) break block6;
                JsonObject object = element.asObject();
                Collection<JsonObject.Key> keys = object.keys();
                IAnnotationModel annotationModel = this.getSourceViewer().getAnnotationModel();
                for (JsonObject.Key key1 : keys) {
                    for (JsonObject.Key key2 : keys) {
                        if (key1 == key2 || !key1.getValue().equals(key2.getValue())) continue;
                        try {
                            IMarker marker = resource.createMarker("org.sweetlemonade.eclipse.json.marker.error");
                            marker.setAttribute("severity", 1);
                            marker.setAttribute("location", (Object)("Line " + key1.getLine()));
                            marker.setAttribute("message", (Object)"Duplicate keys");
                            int start = key1.getStart();
                            int stop = key1.getStop();
                            marker.setAttribute("charStart", start);
                            marker.setAttribute("charEnd", stop);
                            if (hasResource) continue;
                            MarkerAnnotation annotation = new MarkerAnnotation(marker);
                            annotationModel.addAnnotation((Annotation)annotation, new Position(start, stop - start));
                            this.mProblems.put(marker, (Annotation)annotation);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    this.findDupKeys(object.get(key1), resource, hasResource);
                }
                break block7;
            }
            if (!element.isArray()) break block7;
            Collection<JsonElement> childs = element.getChilds();
            for (JsonElement jsonElement : childs) {
                this.findDupKeys(jsonElement, resource, hasResource);
            }
        }
    }

    public void setJsonInput(JsonElement element, Collection<ParseUtils.ParseError> errors) {
        IResource resource = ResourceUtil.getResource((IEditorInput)this.getEditorInput());
        boolean hasResource = true;
        if (resource == null) {
            hasResource = false;
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        if (resource != null) {
            try {
                if (hasResource) {
                    resource.deleteMarkers("org.sweetlemonade.eclipse.json.marker.error", false, 0);
                }
                IAnnotationModel annotationModel = this.getSourceViewer().getAnnotationModel();
                this.clearAnnos();
                for (ParseUtils.ParseError parseError : errors) {
                    IMarker marker = resource.createMarker("org.sweetlemonade.eclipse.json.marker.error");
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("location", (Object)("Line " + parseError.line));
                    marker.setAttribute("message", (Object)parseError.text);
                    if (parseError.start != -1) {
                        marker.setAttribute("charStart", parseError.start);
                        if (parseError.stop != -1) {
                            marker.setAttribute("charEnd", parseError.stop);
                        } else {
                            marker.setAttribute("charEnd", parseError.start + 1);
                        }
                    }
                    if (hasResource) continue;
                    MarkerAnnotation annotation = new MarkerAnnotation(marker);
                    annotationModel.addAnnotation((Annotation)annotation, new Position(parseError.start, 1));
                    this.mProblems.put(marker, (Annotation)annotation);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.findDupKeys(element, resource, hasResource);
        }
        this.mAnnotationer.update(element);
        this.mElement = element;
        this.getOutlinePage().setInput(element);
    }

    private void clearAnnos() {
        IAnnotationModel annotationModel = this.getSourceViewer().getAnnotationModel();
        Set<IMarker> keySet = this.mProblems.keySet();
        for (IMarker iMarker : keySet) {
            try {
                iMarker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (annotationModel == null) continue;
            annotationModel.removeAnnotation(this.mProblems.get(iMarker));
        }
        this.mProblems.clear();
    }

    private JsonOutlinePage getOutlinePage() {
        if (this.mOutlinePage == null) {
            this.mOutlinePage = new JsonOutlinePage(this);
        }
        return this.mOutlinePage;
    }

    public JsonElement getJsonElement() {
        return this.mElement;
    }

    public void dispose() {
        this.clearAnnos();
        super.dispose();
        this.mAnnotationer.dispose();
    }
}

