/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.editor;

import java.util.LinkedList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.sweetlemonade.eclipse.json.editor.JsonEditor;
import org.sweetlemonade.eclipse.json.editor.JsonFormatter;
import org.sweetlemonade.eclipse.json.model.JsonElement;
import org.sweetlemonade.eclipse.json.model.JsonParserMy;

public class JsonFormatStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList<IDocument> mDocuments = new LinkedList();
    private final JsonEditor mEditor;
    private JsonElement mElement;
    private JsonFormatter mFormatter;

    public JsonFormatStrategy(JsonEditor editor) {
        this.mEditor = editor;
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        IDocument document = (IDocument)context.getProperty((Object)"formatting.context.medium");
        this.mElement = new JsonParserMy(document).parse();
        this.mFormatter = new JsonFormatter(this.mElement, this.mEditor.getMergedPreferenceStore());
        this.mDocuments.addLast(document);
    }

    public void format() {
        super.format();
        if (this.mElement == null) {
            return;
        }
        IDocument document = this.mDocuments.removeFirst();
        String format = this.mFormatter.format(document.getLength());
        document.set(format);
        this.mEditor.doSaveAfterFormat();
    }

    public void formatterStops() {
        super.formatterStops();
        this.mDocuments.clear();
    }
}

