/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.editor;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.sweetlemonade.eclipse.json.JsonPlugin;
import org.sweetlemonade.eclipse.json.editor.CharacterRule;
import org.sweetlemonade.eclipse.json.editor.JsonNumberRule;
import org.sweetlemonade.eclipse.json.editor.StringValueRule;
import org.sweetlemonade.eclipse.json.preference.JsonPreferences;
import org.sweetlemonade.eclipse.json.preference.JsonPreferencesInitializer;

public class JsonScanner
extends RuleBasedScanner {
    public JsonScanner() {
        this.updateRules();
    }

    public void updateRules() {
        JsonPreferences preferences = JsonPlugin.getPreferences();
        Token objectBrackets = new Token((Object)new TextAttribute(preferences.getColor(JsonPreferencesInitializer.TokenType.OBJECT_BRACKETS), null, preferences.getStyle(JsonPreferencesInitializer.TokenType.OBJECT_BRACKETS)));
        Token arrayBrackets = new Token((Object)new TextAttribute(preferences.getColor(JsonPreferencesInitializer.TokenType.ARRAY_BRACKETS), null, preferences.getStyle(JsonPreferencesInitializer.TokenType.ARRAY_BRACKETS)));
        Token keys = new Token((Object)new TextAttribute(preferences.getColor(JsonPreferencesInitializer.TokenType.KEYS), null, preferences.getStyle(JsonPreferencesInitializer.TokenType.KEYS)));
        Token strings = new Token((Object)new TextAttribute(preferences.getColor(JsonPreferencesInitializer.TokenType.STRINGS), null, preferences.getStyle(JsonPreferencesInitializer.TokenType.STRINGS)));
        Token numbers = new Token((Object)new TextAttribute(preferences.getColor(JsonPreferencesInitializer.TokenType.NUMBERS), null, preferences.getStyle(JsonPreferencesInitializer.TokenType.NUMBERS)));
        Token booleans = new Token((Object)new TextAttribute(preferences.getColor(JsonPreferencesInitializer.TokenType.BOOLEANS), null, preferences.getStyle(JsonPreferencesInitializer.TokenType.BOOLEANS)));
        Token nulls = new Token((Object)new TextAttribute(preferences.getColor(JsonPreferencesInitializer.TokenType.NULL), null, preferences.getStyle(JsonPreferencesInitializer.TokenType.NULL)));
        IRule[] rules = new IRule[6];
        WordRule keywords = new WordRule(new IWordDetector(){
            final String start = "nft";
            final String part = "nullfalsetrue";

            public boolean isWordStart(char c) {
                return "nft".indexOf(c) != -1;
            }

            public boolean isWordPart(char c) {
                return "nullfalsetrue".indexOf(c) != -1;
            }
        });
        keywords.addWord("null", (IToken)nulls);
        keywords.addWord("false", (IToken)booleans);
        keywords.addWord("true", (IToken)booleans);
        rules[0] = new StringValueRule("\"", "\"", (IToken)strings, '\\');
        rules[1] = new SingleLineRule("\"", "\"", (IToken)keys, '\\');
        rules[2] = new CharacterRule((IToken)objectBrackets, '{', '}');
        rules[3] = new CharacterRule((IToken)arrayBrackets, '[', ']');
        rules[4] = keywords;
        rules[5] = new JsonNumberRule((IToken)numbers);
        this.setRules(rules);
        this.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(JsonPlugin.getPreferences().getColor(JsonPreferencesInitializer.TokenType.DEFAULT))));
    }
}

