/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.sweetlemonade.eclipse.json.model.JsonElement;

public class JsonObject
extends JsonElement
implements Map<Key, JsonElement> {
    private final ArrayList<Key> mKeys = new ArrayList();
    private final ArrayList<JsonElement> mValues = new ArrayList();

    public JsonObject(JsonElement parent) {
        super(parent);
    }

    @Override
    public void clear() {
        this.mKeys.clear();
        this.mValues.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mKeys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mValues.contains(value);
    }

    @Override
    public Set<Map.Entry<Key, JsonElement>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonElement get(Object key) {
        int indexOf = this.mKeys.indexOf(key);
        return indexOf == -1 ? null : this.mValues.get(indexOf);
    }

    @Override
    public boolean isEmpty() {
        return this.mKeys.isEmpty();
    }

    public Collection<Key> keys() {
        return Collections.unmodifiableList(this.mKeys);
    }

    @Override
    public Set<Key> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonElement put(Key key, JsonElement value) {
        JsonElement was = this.get(key);
        this.mKeys.add(key);
        this.mValues.add(value);
        return was;
    }

    @Override
    public JsonElement put(String key, JsonElement value) {
        return this.put(new Key(key), value);
    }

    @Override
    public void putAll(Map<? extends Key, ? extends JsonElement> m) {
        Set<? extends Key> keySet = m.keySet();
        for (Key key : keySet) {
            this.put(key, m.get(key));
        }
    }

    @Override
    public JsonElement remove(Object key) {
        int indexOf = this.mKeys.indexOf(key);
        if (indexOf == -1) {
            return null;
        }
        this.mKeys.remove(key);
        return this.mValues.remove(indexOf);
    }

    @Override
    public int size() {
        return this.mKeys.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int i = 0;
        while (i < this.mKeys.size()) {
            if (i > 0) {
                builder.append(", ");
            }
            Key key = this.mKeys.get(i);
            JsonElement value = this.mValues.get(i);
            builder.append(key.getValue());
            builder.append('=');
            if (value == this) {
                builder.append("this object");
            } else {
                builder.append(value);
            }
            ++i;
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public Collection<JsonElement> values() {
        return Collections.unmodifiableList(this.mValues);
    }

    @Override
    public boolean hasChilds() {
        return !this.isEmpty();
    }

    public static class Key {
        private final String mValue;
        private int mStart = -1;
        private int mStop = -1;
        private int mLine;

        public Key(String value) {
            this.mValue = value;
        }

        public String getValue() {
            return this.mValue;
        }

        public void setLine(int line) {
            this.mLine = line;
        }

        public int getLine() {
            return this.mLine;
        }

        public void setStart(int start) {
            this.mStart = start;
        }

        public void setStop(int stop) {
            this.mStop = stop;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getStop() {
            return this.mStop;
        }

        public String toString() {
            return this.mValue;
        }
    }
}

