/*
 * Decompiled with CFR 0.152.
 */
package org.sweetlemonade.eclipse.json.preference.colors;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.sweetlemonade.eclipse.json.Container;
import org.sweetlemonade.eclipse.json.JsonPlugin;
import org.sweetlemonade.eclipse.json.preference.JsonPreferences;
import org.sweetlemonade.eclipse.json.preference.JsonPreferencesInitializer;
import org.sweetlemonade.eclipse.json.preference.PseudoPreferenceStore;
import org.sweetlemonade.eclipse.json.preference.colors.ColorsContentProvider;
import org.sweetlemonade.eclipse.json.preference.colors.ColorsLabelProvider;
import org.sweetlemonade.eclipse.json.preference.colors.JavaColorPrefsCopier;
import org.sweetlemonade.eclipse.json.preference.colors.TextHighlighter;

public class JsonSyntaxColorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ISelectionChangedListener,
IPropertyChangeListener,
SelectionListener {
    private final PseudoPreferenceStore mPreferenceStore = new PseudoPreferenceStore();
    private Button mEnabledButton;
    private JsonPreferencesInitializer.TokenType mSelection;
    private ColorSelector mSelector;
    private TextHighlighter mHighlighter;
    private Button mBoldButton;
    private Button mItalicButton;
    private Button mUnderButton;
    private Button mStrikeButton;
    private Button mCopyJavaPrefsButton;
    private JavaColorPrefsCopier mCopier;

    public JsonSyntaxColorsPreferencePage() {
        JsonPreferencesInitializer.TokenType[] types;
        IPreferenceStore store = JsonPlugin.getDefault().getPreferenceStore();
        JsonPreferencesInitializer.TokenType[] tokenTypeArray = types = JsonPreferencesInitializer.TokenType.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            JsonPreferencesInitializer.TokenType colorType = tokenTypeArray[n2];
            this.mPreferenceStore.setValue(colorType.getKey(), StringConverter.asString((RGB)colorType.getOwnColor(store)));
            this.mPreferenceStore.setValue(colorType.getEnabledKey(), colorType.isEnabled(store));
            this.mPreferenceStore.setValue(colorType.getStyleKey(), colorType.getOwnStyle(store));
            ++n2;
        }
    }

    protected Control createContents(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        appearanceComposite.setLayout((Layout)new FormLayout());
        ListViewer listViewer = new ListViewer(appearanceComposite, 2560);
        List list = listViewer.getList();
        FormData fd_list = new FormData();
        fd_list.top = new FormAttachment(0, 0);
        fd_list.left = new FormAttachment(0, 0);
        list.setLayoutData((Object)fd_list);
        this.mEnabledButton = new Button(appearanceComposite, 32);
        FormData fd_btnCheckButton = new FormData();
        fd_btnCheckButton.top = new FormAttachment(0, 0);
        fd_btnCheckButton.left = new FormAttachment((Control)list, 10);
        this.mEnabledButton.setLayoutData((Object)fd_btnCheckButton);
        this.mEnabledButton.setText("Enabled");
        this.mEnabledButton.addSelectionListener((SelectionListener)this);
        this.mSelector = new ColorSelector(appearanceComposite);
        Button colorButton = this.mSelector.getButton();
        FormData fd_btnColorButton = new FormData();
        fd_btnColorButton.top = new FormAttachment((Control)this.mEnabledButton, 10);
        fd_btnColorButton.left = new FormAttachment((Control)list, 10);
        colorButton.setLayoutData((Object)fd_btnColorButton);
        this.mSelector.addListener((IPropertyChangeListener)this);
        TextViewer textViewer = new TextViewer(appearanceComposite, 2048);
        StyledText styledText = textViewer.getTextWidget();
        FormData fd_styledText = new FormData();
        fd_styledText.bottom = new FormAttachment(100, 0);
        fd_styledText.right = new FormAttachment(100, 0);
        fd_styledText.top = new FormAttachment((Control)list, 10);
        fd_styledText.left = new FormAttachment(0, 0);
        styledText.setLayoutData((Object)fd_styledText);
        textViewer.setEditable(false);
        this.mHighlighter = new TextHighlighter(textViewer, this.mPreferenceStore);
        this.mBoldButton = new Button(appearanceComposite, 32);
        FormData fd_btnBold = new FormData();
        fd_btnBold.top = new FormAttachment((Control)colorButton, 10);
        fd_btnBold.left = new FormAttachment((Control)list, 10);
        this.mBoldButton.setLayoutData((Object)fd_btnBold);
        this.mBoldButton.setText("Bold");
        this.mBoldButton.addSelectionListener((SelectionListener)this);
        this.mItalicButton = new Button(appearanceComposite, 32);
        FormData fd_btnCheckButton0 = new FormData();
        fd_btnCheckButton0.top = new FormAttachment((Control)this.mBoldButton, 10);
        fd_btnCheckButton0.left = new FormAttachment((Control)list, 10);
        this.mItalicButton.setLayoutData((Object)fd_btnCheckButton0);
        this.mItalicButton.setText("Italic");
        this.mItalicButton.addSelectionListener((SelectionListener)this);
        this.mUnderButton = new Button(appearanceComposite, 32);
        FormData fd_btnCheckButton_1 = new FormData();
        fd_btnCheckButton_1.top = new FormAttachment((Control)colorButton, 10);
        fd_btnCheckButton_1.left = new FormAttachment((Control)this.mItalicButton, 10);
        this.mUnderButton.setLayoutData((Object)fd_btnCheckButton_1);
        this.mUnderButton.setText("Underline");
        this.mUnderButton.addSelectionListener((SelectionListener)this);
        this.mStrikeButton = new Button(appearanceComposite, 32);
        FormData fd_btnCheckButton_2 = new FormData();
        fd_btnCheckButton_2.top = new FormAttachment((Control)this.mUnderButton, 10);
        fd_btnCheckButton_2.left = new FormAttachment((Control)this.mItalicButton, 10);
        this.mStrikeButton.setLayoutData((Object)fd_btnCheckButton_2);
        this.mStrikeButton.setText("Strikethrough");
        this.mStrikeButton.addSelectionListener((SelectionListener)this);
        if (JavaColorPrefsCopier.mayCopyJavaColorPrefs()) {
            this.mCopyJavaPrefsButton = new Button(appearanceComposite, 0);
            FormData fd_btnCopyJavaPrefs = new FormData();
            fd_btnCopyJavaPrefs.top = new FormAttachment(0, 10);
            fd_btnCopyJavaPrefs.right = new FormAttachment(100, -10);
            this.mCopyJavaPrefsButton.setLayoutData((Object)fd_btnCopyJavaPrefs);
            this.mCopyJavaPrefsButton.setText("Copy Java prefs");
            this.mCopyJavaPrefsButton.addSelectionListener((SelectionListener)this);
        }
        listViewer.setContentProvider((IContentProvider)new ColorsContentProvider());
        listViewer.setLabelProvider((IBaseLabelProvider)new ColorsLabelProvider());
        listViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        JsonPreferencesInitializer.TokenType[] values = JsonPreferencesInitializer.TokenType.values();
        listViewer.setInput((Object)new Container(values));
        if (this.mSelection == null) {
            listViewer.setSelection((ISelection)new StructuredSelection((Object)values[0]));
        }
        this.mHighlighter.update();
        return appearanceComposite;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.mSelection = (JsonPreferencesInitializer.TokenType)((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
        this.updateSelection();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("colorValue".equals(event.getProperty())) {
            this.mPreferenceStore.setValue(this.mSelection.getKey(), StringConverter.asString((RGB)((RGB)event.getNewValue())));
            this.mHighlighter.update();
        }
    }

    private void updateSelection() {
        int style = this.mSelection.getOwnStyle(this.mPreferenceStore);
        this.mSelector.setColorValue(this.mSelection.getOwnColor(this.mPreferenceStore));
        this.mBoldButton.setSelection(JsonPreferences.isBold(style));
        this.mItalicButton.setSelection(JsonPreferences.isItalic(style));
        this.mUnderButton.setSelection(JsonPreferences.isUnderline(style));
        this.mStrikeButton.setSelection(JsonPreferences.isStrike(style));
        if (this.mSelection == JsonPreferencesInitializer.TokenType.DEFAULT) {
            this.mEnabledButton.setSelection(true);
            this.mEnabledButton.setEnabled(false);
        } else {
            this.mEnabledButton.setEnabled(true);
            this.mEnabledButton.setSelection(this.mSelection.isEnabled(this.mPreferenceStore));
        }
        this.mHighlighter.update();
    }

    public boolean performOk() {
        JsonPreferencesInitializer.TokenType[] types;
        IPreferenceStore store = JsonPlugin.getDefault().getPreferenceStore();
        JsonPreferencesInitializer.TokenType[] tokenTypeArray = types = JsonPreferencesInitializer.TokenType.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            JsonPreferencesInitializer.TokenType type = tokenTypeArray[n2];
            store.setValue(type.getEnabledKey(), type.isEnabled(this.mPreferenceStore));
            store.setValue(type.getKey(), StringConverter.asString((RGB)type.getOwnColor(this.mPreferenceStore)));
            store.setValue(type.getStyleKey(), type.getOwnStyle(this.mPreferenceStore));
            ++n2;
        }
        return true;
    }

    protected void performDefaults() {
        JsonPreferencesInitializer.TokenType[] types;
        super.performDefaults();
        IPreferenceStore store = JsonPlugin.getDefault().getPreferenceStore();
        JsonPreferencesInitializer.TokenType[] tokenTypeArray = types = JsonPreferencesInitializer.TokenType.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            JsonPreferencesInitializer.TokenType type = tokenTypeArray[n2];
            this.mPreferenceStore.setValue(type.getEnabledKey(), store.getDefaultBoolean(type.getEnabledKey()));
            this.mPreferenceStore.setValue(type.getKey(), store.getDefaultString(type.getKey()));
            this.mPreferenceStore.setValue(type.getStyleKey(), store.getDefaultInt(type.getStyleKey()));
            ++n2;
        }
        this.updateSelection();
        this.mHighlighter.update();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(JsonPlugin.getDefault().getPreferenceStore());
    }

    private int collectStyle() {
        boolean bold = this.mBoldButton.getSelection();
        boolean italic = this.mItalicButton.getSelection();
        boolean under = this.mUnderButton.getSelection();
        boolean strike = this.mStrikeButton.getSelection();
        return JsonPreferences.mergeStyles(bold, italic, under, strike);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.mEnabledButton) {
            this.mPreferenceStore.setValue(this.mSelection.getEnabledKey(), this.mEnabledButton.getSelection());
        } else if (this.mCopyJavaPrefsButton != null && e.widget == this.mCopyJavaPrefsButton) {
            if (this.mCopier == null) {
                this.mCopier = new JavaColorPrefsCopier();
            }
            this.mCopier.copyPrefs(this.mPreferenceStore);
            this.updateSelection();
        } else {
            this.mPreferenceStore.setValue(this.mSelection.getStyleKey(), this.collectStyle());
        }
        this.mHighlighter.update();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.mEnabledButton) {
            this.mPreferenceStore.setValue(this.mSelection.getEnabledKey(), this.mEnabledButton.getSelection());
        } else if (this.mCopyJavaPrefsButton == null || e.widget != this.mCopyJavaPrefsButton) {
            this.mPreferenceStore.setValue(this.mSelection.getStyleKey(), this.collectStyle());
        }
        this.mHighlighter.update();
    }
}

