/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical.config;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.EditableRule;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalTreeAlternatingRowConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.hierarchical.HierarchicalTreeLayer;
import org.eclipse.nebula.widgets.nattable.hierarchical.action.HierarchicalTreeColumnReorderDragMode;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.tree.action.TreeExpandCollapseAction;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.tree.painter.TreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.action.AggregateDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.CellDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.NoOpMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.CellPainterMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;

public class DefaultHierarchicalTreeLayerConfiguration
implements IConfiguration {
    protected HierarchicalTreeLayer treeLayer;
    public Color evenRowBgColor = GUIHelper.COLOR_WHITE;
    public Color oddRowBgColor = GUIHelper.COLOR_WIDGET_BACKGROUND;
    public Color levelHeaderColor = GUIHelper.COLOR_WIDGET_BACKGROUND;
    public Color levelHeaderSelectedColor = GUIHelper.COLOR_GRAY;

    public DefaultHierarchicalTreeLayerConfiguration(HierarchicalTreeLayer treeLayer) {
        this.treeLayer = treeLayer;
    }

    @Override
    public void configureLayer(ILayer layer) {
        HierarchicalTreeAlternatingRowConfigLabelAccumulator accumulator = new HierarchicalTreeAlternatingRowConfigLabelAccumulator(this.treeLayer);
        this.treeLayer.setConfigLabelAccumulator(accumulator);
        this.treeLayer.addLayerListener(accumulator);
        this.treeLayer.registerCommandHandler(accumulator);
        accumulator.calculateLabels();
    }

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        PaddingDecorator treeImagePainter = new PaddingDecorator(new TreeImagePainter(), 5, 2, 5, 2);
        IndentedTreeImagePainter treePainter = new IndentedTreeImagePainter(0, CellEdgeEnum.TOP_LEFT, treeImagePainter);
        treePainter.getInternalPainter().setPaintDecorationDependent(false);
        BackgroundPainter treeStructurePainter = new BackgroundPainter(treePainter);
        configRegistry.registerConfigAttribute(TreeConfigAttributes.TREE_STRUCTURE_PAINTER, treeStructurePainter, "NORMAL");
        PaddingDecorator basePainter = new PaddingDecorator(new TextPainter(), 2, 2, 2, 15);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, basePainter, "NORMAL", "TREE_COLUMN_CELL");
        Style treeStyle = new Style();
        treeStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, VerticalAlignmentEnum.TOP);
        treeStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, HorizontalAlignmentEnum.LEFT);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, treeStyle, "NORMAL", "TREE_COLUMN_CELL");
        Style levelHeaderStyle = new Style();
        levelHeaderStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.levelHeaderColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, levelHeaderStyle, "NORMAL", "LEVEL_HEADER_CELL");
        Style levelHeaderSelectedStyle = new Style();
        levelHeaderSelectedStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.levelHeaderSelectedColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, levelHeaderSelectedStyle, "SELECT", "LEVEL_HEADER_CELL");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, new BackgroundPainter(), "NORMAL", "COLLAPSED_CHILD");
        Style evenRowCellStyle = new Style();
        evenRowCellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.evenRowBgColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, evenRowCellStyle, "NORMAL", "EVEN_BODY");
        Style oddRowCellStyle = new Style();
        oddRowCellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.oddRowBgColor);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, oddRowCellStyle, "NORMAL", "ODD_BODY");
        this.configureEditableRules(configRegistry);
    }

    protected void configureEditableRules(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, EditableRule.NEVER_EDITABLE, "NORMAL", "LEVEL_HEADER_CELL");
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, EditableRule.NEVER_EDITABLE, "NORMAL", "COLLAPSED_CHILD");
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, EditableRule.NEVER_EDITABLE, "NORMAL", "NO_OBJECT_IN_LEVEL");
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        TreeExpandCollapseAction treeExpandCollapseAction = new TreeExpandCollapseAction();
        CellPainterMouseEventMatcher treeImagePainterMouseEventMatcher = new CellPainterMouseEventMatcher("BODY", 1, TreeImagePainter.class);
        uiBindingRegistry.registerFirstSingleClickBinding(treeImagePainterMouseEventMatcher, treeExpandCollapseAction);
        uiBindingRegistry.registerFirstMouseDownBinding(treeImagePainterMouseEventMatcher, new NoOpMouseAction());
        uiBindingRegistry.registerMouseDragMode(MouseEventMatcher.columnHeaderLeftClick(0), new AggregateDragMode(new CellDragMode(), new HierarchicalTreeColumnReorderDragMode(this.treeLayer)));
    }
}

