/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.actions;

import java.util.HashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionsWithSelection;
import name.schedenig.eclipse.grepconsole.view.items.ExpressionDialog;
import name.schedenig.eclipse.grepconsole.view.items.FolderDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class AddExpressionToFolderAction
extends Action {
    private GrepExpressionFolder folder;
    private GrepPageParticipant participant;
    private String text;
    private Shell shell;

    public AddExpressionToFolderAction(Shell shell, GrepPageParticipant participant, GrepExpressionFolder folder, String text) {
        this.shell = shell;
        this.participant = participant;
        this.folder = folder;
        this.text = text;
        this.setText(folder == null ? Messages.AddExpressionToFolderAction_new_folder : folder.getName());
    }

    public void run() {
        Object dlg;
        GrepExpressionFolder folder;
        Activator activator = Activator.getDefault();
        GrepExpressionsWithSelection expressions = new GrepExpressionsWithSelection(activator.getExpressions().copy(true), null, null, null, null);
        if (this.participant != null) {
            expressions.setEnablementMap(new HashMap<String, Boolean>(this.participant.getEnablementMap()));
            expressions.setFilterMap(new HashMap<String, Boolean>(this.participant.getFilterMap()));
            expressions.setStatisticsMap(new HashMap<String, Boolean>(this.participant.getStatisticsMap()));
            expressions.setNotificationsMap(new HashMap<String, Boolean>(this.participant.getNotificationsMap()));
        }
        if ((folder = this.folder) == null) {
            folder = new GrepExpressionFolder();
            String title = this.participant == null || this.participant.getLaunchConfig() == null ? Messages.AddExpressionToFolderAction_new_folder : this.participant.getLaunchConfig().getName();
            folder.setName(title);
            dlg = new FolderDialog(this.shell, folder, true);
            if (dlg.open() != 0) {
                return;
            }
            expressions.getRootFolder().add(folder);
            if (expressions.getEnablementMap() != null) {
                expressions.getEnablementMap().put(folder.getId(), true);
            }
        } else {
            folder = (GrepExpressionFolder)expressions.getRootFolder().findById(folder.getId());
        }
        GrepExpressionItem expression = new GrepExpressionItem();
        expression.setGrepExpression("(" + Pattern.quote(this.text) + ")");
        folder.add(expression);
        dlg = new ExpressionDialog(this.shell, true);
        ((ExpressionDialog)dlg).setPreviewText(this.participant.getStyledText().getText());
        ((ExpressionDialog)dlg).setItem(expression);
        if (dlg.open() == 0) {
            activator.getExpressions().copyFrom(expressions.getRootFolder(), true);
            if (this.participant != null) {
                this.participant.saveLaunchConfig();
            }
            try {
                activator.saveSettings();
            }
            catch (ParserConfigurationException ex) {
                Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
            }
            catch (TransformerException ex) {
                Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
            }
            catch (BackingStoreException ex) {
                Activator.getDefault().log(4, Messages.Error_could_not_save_settings, ex);
            }
            Activator.getDefault().doSettingsChanged();
        }
    }
}

