/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.actions;

import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.view.common.GrepConsoleView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.console.IConsole;

public class SelectConsoleAction
extends Action
implements IMenuCreator {
    private IConsole console;
    private Menu menu;
    private GrepConsoleView view;

    public SelectConsoleAction(GrepConsoleView view) {
        super(Messages.SelectConsoleAction_display_selected_console, 4);
        this.view = view;
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("action.select_console"));
        this.setMenuCreator(this);
    }

    public SelectConsoleAction(GrepConsoleView view, IConsole console) {
        super(console.getName(), 8);
        this.view = view;
        this.console = console;
        this.setChecked(view.getConsole() == console);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public void run() {
        GrepPageParticipant participant;
        this.view.setConsole(this.console);
        if (this.view.isLinkedToConsole() && (participant = Activator.getDefault().getParticipant(this.console)) != null) {
            participant.setFocus();
        }
    }

    public Menu getMenu(Control parent) {
        this.dispose();
        this.menu = new Menu(parent);
        Activator plugin = Activator.getDefault();
        for (IConsole console : plugin.getParticipants().keySet()) {
            GrepConsoleUtil.addActionToMenu(this.menu, (IAction)new SelectConsoleAction(this.view, console));
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

