/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.GrepLineStyleListener;
import name.schedenig.eclipse.grepconsole.adapters.GrepPageParticipant;
import name.schedenig.eclipse.grepconsole.adapters.GrepStyleRange;
import name.schedenig.eclipse.grepconsole.adapters.GroupParameterResolver;
import name.schedenig.eclipse.grepconsole.adapters.IStatisticsListener;
import name.schedenig.eclipse.grepconsole.adapters.StatisticsEntry;
import name.schedenig.eclipse.grepconsole.adapters.links.GrepLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.view.notifications.GrepConsoleNotification;
import name.schedenig.eclipse.popupnotifications.INotificationListener;
import name.schedenig.eclipse.popupnotifications.Notification;
import name.schedenig.eclipse.popupnotifications.PopupNotificationManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.widgets.Shell;

public class TextFilter
implements TextChangeListener,
StyledTextContent,
Activator.IGrepConsoleListener,
INotificationListener {
    public static final String DELIMITER_CHARS = "\n\r";
    private StyledTextContent originalContent;
    private LinkedList<GrepExpressionItem> filterExpressions;
    private LinkedHashSet<GrepExpressionItem> statisticsExpressions;
    private LinkedList<Line> lines = new LinkedList();
    private LinkedList<Integer> lineOffsets = new LinkedList();
    private LinkedList<Integer> originalOffsets = new LinkedList();
    private int charCount;
    private String delimiter;
    private StringBuilder bufferedText;
    private Set<Character> usedDelimiters;
    private boolean sentChanging;
    private LinkedHashSet<TextChangeListener> listeners = new LinkedHashSet();
    private int matchLength;
    private int originalOffset;
    private int originalOffsetDelta;
    private int maxProcessedLineOffset = -1;
    private Shell shell;
    private IProject project;
    private Set<GrepExpressionItem> actionItems;
    private LinkedHashSet<GrepExpressionItem> notificationExpressions;
    private LinkedHashSet<GrepExpressionItem> errorLogExpressions;
    private Map<String, StatisticsEntry> statisticEntries;
    private LinkedHashSet<IStatisticsListener> statisticsListeners = new LinkedHashSet();

    public TextFilter(StyledTextContent originalContent, LinkedList<GrepExpressionItem> filterExpressions, LinkedHashSet<GrepExpressionItem> statisticsExpressions, LinkedHashSet<GrepExpressionItem> notificationExpressions, LinkedHashSet<GrepExpressionItem> errorLogExpressions, Shell shell, IProject project) {
        this.originalContent = originalContent;
        this.filterExpressions = filterExpressions;
        this.statisticsExpressions = statisticsExpressions;
        this.notificationExpressions = notificationExpressions;
        this.errorLogExpressions = errorLogExpressions;
        this.shell = shell;
        this.project = project;
        Activator activator = Activator.getDefault();
        activator.addListener(this);
        this.matchLength = activator.getFilterMatchLength();
        this.statisticEntries = new HashMap<String, StatisticsEntry>();
        this.delimiter = System.getProperty("line.separator");
    }

    public void setLineDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void dispose() {
        this.unhookListener();
        Activator.getDefault().removeListener(this);
    }

    public StyledTextContent getOriginalContent() {
        return this.originalContent;
    }

    public void refresh() {
        this.clearStatistics();
        String text = this.filterExpressions.isEmpty() ? "" : this.originalContent.getTextRange(0, this.originalContent.getCharCount());
        this.setText(text);
        if (this.filterExpressions.isEmpty() && this.statisticsExpressions.isEmpty() && this.notificationExpressions.isEmpty() && this.errorLogExpressions.isEmpty()) {
            this.unhookListener();
        } else {
            this.hookListener();
        }
    }

    public void setText(String s) {
        this.clear();
        this.bufferedText = new StringBuilder();
        this.usedDelimiters = new HashSet<Character>();
        if (s.length() > 0) {
            this.handleNewText(s, false);
        }
        TextChangedEvent event = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener listener : this.listeners) {
            listener.textSet(event);
        }
    }

    private void clear() {
        this.lines.clear();
        this.lineOffsets.clear();
        this.originalOffsets.clear();
        this.charCount = 0;
        this.originalOffset = 0;
        this.originalOffsetDelta = 0;
        this.clearStatistics();
    }

    private void clearStatistics() {
        for (StatisticsEntry entry : this.statisticEntries.values()) {
            this.fireStatisticsRemoved(entry);
        }
        this.statisticEntries.clear();
    }

    public void hookListener() {
        if (!(this.filterExpressions.isEmpty() && this.statisticsExpressions.isEmpty() && this.notificationExpressions.isEmpty() && this.errorLogExpressions.isEmpty())) {
            this.originalContent.addTextChangeListener((TextChangeListener)this);
        }
    }

    public void unhookListener() {
        this.originalContent.removeTextChangeListener((TextChangeListener)this);
    }

    public static boolean isDelimiterChar(char c) {
        return DELIMITER_CHARS.indexOf(c) >= 0;
    }

    protected TextChangingEvent handleNewText(String s, boolean notifications) {
        TextChangingEvent event = new TextChangingEvent((StyledTextContent)this);
        StringBuilder newText = new StringBuilder();
        event.start = this.charCount;
        int startIndex = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (TextFilter.isDelimiterChar(c)) {
                if (this.usedDelimiters.isEmpty() || this.usedDelimiters.contains(Character.valueOf(c))) {
                    String line = String.valueOf(this.bufferedText.toString()) + s.substring(startIndex, i);
                    if (this.handleNewLine(line, notifications)) {
                        event.newCharCount += line.length() + this.delimiter.length();
                        ++event.newLineCount;
                        newText.append(line);
                    }
                    this.originalOffset += line.length() + 1;
                    this.bufferedText = new StringBuilder();
                    startIndex = i + 1;
                } else {
                    startIndex = i + 1;
                    ++this.originalOffset;
                }
            } else {
                this.usedDelimiters.clear();
            }
            ++i;
        }
        if (startIndex < s.length()) {
            this.bufferedText.append(s.substring(startIndex));
        }
        if (event.newCharCount == 0) {
            return null;
        }
        event.newText = newText.toString();
        return event;
    }

    private boolean handleNewLine(String line, boolean notifications) {
        Pattern pattern;
        Matcher matcher;
        boolean notYetProcessed;
        boolean filter = !this.listeners.isEmpty();
        int cutoff = line.length();
        while (cutoff > 0) {
            char c = line.charAt(cutoff - 1);
            if (c != '\n' && c != '\r') break;
            --cutoff;
        }
        boolean result = false;
        LinkedHashSet<GrepExpressionItem> remainingActionItems = null;
        boolean bl = notYetProcessed = this.originalOffset >= this.maxProcessedLineOffset;
        if (!this.statisticsExpressions.isEmpty() || notifications && notYetProcessed) {
            remainingActionItems = new LinkedHashSet<GrepExpressionItem>(this.getActionItems(notYetProcessed));
        }
        List<GrepExpressionItem> filterExpressions = filter ? this.filterExpressions : Collections.emptyList();
        line = line.substring(0, cutoff);
        for (GrepExpressionItem item : filterExpressions) {
            Matcher unlessMatcher;
            Pattern unlessPattern;
            String matchLine;
            if (remainingActionItems != null) {
                remainingActionItems.remove(item);
            }
            Pattern quickPattern = item.getQuickPattern();
            String string = matchLine = this.matchLength <= 0 || line.length() <= this.matchLength ? line : line.substring(0, this.matchLength);
            if (quickPattern != null) {
                if (!quickPattern.matcher(matchLine).find()) continue;
                matchLine = line;
            }
            if (!(matcher = (pattern = item.getPattern()).matcher(matchLine)).find() || (unlessPattern = item.getUnlessPattern()) != null && (unlessMatcher = unlessPattern.matcher(matchLine)).find()) continue;
            if (remainingActionItems != null) {
                if (this.statisticsExpressions.contains(item)) {
                    this.handleMatchedStatisticsItem(item, matchLine, matcher);
                }
                if (notifications && notYetProcessed && this.notificationExpressions.contains(item)) {
                    this.handleMatchedNotificationsItem(item, matchLine, matcher);
                }
                if (notifications && notYetProcessed && this.errorLogExpressions.contains(item)) {
                    this.handleMatchedErrorLogItem(item, matchLine, matcher);
                }
            }
            if (item.getRewriteExpression() == null) {
                this.addLine(line, false, null);
            } else {
                GrepStyleRange[] ranges;
                LinkedList<int[]> rangeIndices = new LinkedList<int[]>();
                LinkMatch linkMatch = new LinkMatch(item, item.getAutostartLink(), matcher.toMatchResult(), matcher.start(), line, 0, this.project);
                String rewritten = GrepConsoleUtil.replaceParams(item.getRewriteExpression(), matcher.toMatchResult(), line, -1, rangeIndices, this.project, new GroupParameterResolver(linkMatch));
                GrepGroup[] groups = item.getRewriteGroups();
                if (groups == null || groups.length == 0) {
                    ranges = null;
                } else {
                    LinkedList<GrepStyleRange> rangeList = new LinkedList<GrepStyleRange>();
                    if (groups[0] != null && (groups[0].getStyle() != null || groups[0].getLink() != null)) {
                        rangeList.add(new GrepStyleRange(item, 0, true, 0, rewritten.length() - 1, groups[0].getStyle(), groups[0].getLink(), matcher, rewritten, 0, this.project));
                    }
                    int i = 0;
                    for (int[] indices : rangeIndices) {
                        if (groups[++i] == null || groups[i].getStyle() == null && groups[i].getLink() == null) continue;
                        GrepStyleRange range = new GrepStyleRange(item, 0, false, indices[0], indices[1], groups[i].getStyle(), groups[i].getLink(), matcher, rewritten, -1, this.project);
                        rangeList.add(range);
                    }
                    ranges = rangeList.isEmpty() ? null : rangeList.toArray(new GrepStyleRange[rangeList.size()]);
                }
                this.addLine(rewritten, true, ranges);
            }
            result = true;
            break;
        }
        if (remainingActionItems != null && !remainingActionItems.isEmpty()) {
            String matchLine = this.matchLength <= 0 || line.length() <= this.matchLength ? line : line.substring(0, this.matchLength);
            for (GrepExpressionItem item : remainingActionItems) {
                Pattern quickPattern;
                if (!this.statisticsExpressions.contains(item) && !this.notificationExpressions.contains(item) && !this.errorLogExpressions.contains(item) || (quickPattern = item.getQuickPattern()) != null && !quickPattern.matcher(matchLine).find() || !(matcher = (pattern = item.getPattern()).matcher(matchLine)).find()) continue;
                if (this.statisticsExpressions.contains(item)) {
                    this.handleMatchedStatisticsItem(item, line, matcher);
                }
                if (notifications && notYetProcessed && this.notificationExpressions.contains(item)) {
                    this.handleMatchedNotificationsItem(item, line, matcher);
                }
                if (!notifications || !notYetProcessed || !this.errorLogExpressions.contains(item)) continue;
                this.handleMatchedErrorLogItem(item, matchLine, matcher);
            }
        }
        return result;
    }

    private void handleMatchedNotificationsItem(GrepExpressionItem item, String line, Matcher matcher) {
        LinkMatch linkMatch = item.isPopupNotification() || item.getAutostartLink() != null || item.getErrorLogLevel() > 0 ? new LinkMatch(item, item.getAutostartLink(), matcher.toMatchResult(), matcher.start(), line, 0, this.project) : null;
        if (item.getSoundNotificationPath() != null) {
            this.playSound(item.getSoundNotificationPath());
        }
        if (item.isPopupNotification()) {
            Notification notification = this.createNotification(linkMatch);
            PopupNotificationManager man = name.schedenig.eclipse.popupnotifications.Activator.getDefault().getManager();
            man.addNotification(notification);
        }
        if (item.getAutostartLink() != null) {
            this.executeLink(linkMatch);
        }
    }

    private void handleMatchedErrorLogItem(GrepExpressionItem item, String line, Matcher matcher) {
        if (item.getErrorLogLevel() <= 0) {
            return;
        }
        LinkMatch linkMatch = new LinkMatch(item, item.getAutostartLink(), matcher.toMatchResult(), matcher.start(), line, 0, this.project);
        IStatus status = this.createEclipseLogEntry(linkMatch);
        Activator.getDefault().getLog().log(status);
    }

    private void handleMatchedStatisticsItem(GrepExpressionItem item, String line, Matcher matcher) {
        if (item.getStatisticsCountLabel() != null) {
            boolean isNew;
            String label = item.getStatisticsCountLabel();
            StatisticsEntry entry = this.statisticEntries.get(label);
            if (entry == null) {
                entry = new StatisticsEntry(StatisticsEntry.Type.COUNT, label, 1);
                this.statisticEntries.put(label, entry);
                isNew = true;
            } else {
                int value = entry.getValue() instanceof Integer ? (Integer)entry.getValue() : 0;
                entry.setValue(value + 1);
                isNew = false;
            }
            this.fireStatisticsUpdated(entry, isNew);
        }
        if (item.getStatisticsValueLabel() != null) {
            boolean isNew;
            String value;
            if (item.getStatisticsValuePattern() == null) {
                value = matcher.group(0);
            } else {
                LinkedList<int[]> rangeIndices = new LinkedList<int[]>();
                LinkMatch linkMatch = new LinkMatch(item, item.getAutostartLink(), matcher.toMatchResult(), matcher.start(), line, 0, this.project);
                value = GrepConsoleUtil.replaceParams(item.getStatisticsValuePattern(), matcher.toMatchResult(), line, -1, rangeIndices, this.project, new GroupParameterResolver(linkMatch));
            }
            String label = item.getStatisticsValueLabel();
            StatisticsEntry entry = this.statisticEntries.get(label);
            if (entry == null) {
                entry = new StatisticsEntry(StatisticsEntry.Type.LABEL, label, value);
                this.statisticEntries.put(label, entry);
                isNew = true;
            } else {
                entry.setValue(value);
                isNew = false;
            }
            this.fireStatisticsUpdated(entry, isNew);
        }
    }

    private void playSound(String path) {
        Activator activator = Activator.getDefault();
        try {
            activator.getSoundManager().playSound(path);
        }
        catch (UnsupportedAudioFileException ex) {
            activator.log(4, ex);
        }
        catch (IOException ex) {
            activator.log(4, ex);
        }
        catch (LineUnavailableException ex) {
            activator.log(4, ex);
        }
    }

    private Notification createNotification(LinkMatch linkMatch) {
        GrepConsoleNotification notification = new GrepConsoleNotification(linkMatch);
        GrepExpressionItem item = linkMatch.getItem();
        GroupParameterResolver resolver = new GroupParameterResolver(linkMatch);
        notification.setTitle(GrepConsoleUtil.replaceParams(item.getNotificationTitle(), linkMatch, resolver));
        notification.setMessage(GrepConsoleUtil.replaceParams(item.getNotificationMessage(), linkMatch, resolver));
        notification.setStyle(Activator.getDefault().getNotificationStyle());
        notification.addListener(this);
        return notification;
    }

    private IStatus createEclipseLogEntry(LinkMatch linkMatch) {
        GrepExpressionItem item = linkMatch.getItem();
        String msg = item.getErrorLogMessage() == null ? linkMatch.getWholeLine() : GrepConsoleUtil.replaceParams(item.getErrorLogMessage(), linkMatch.getMatchResult(), linkMatch.getWholeLine(), -1, null, this.project, new GroupParameterResolver(linkMatch));
        Status status = new Status(item.getErrorLogLevel(), "name.schedenig.eclipse.grepconsole", msg);
        return status;
    }

    private Set<GrepExpressionItem> getActionItems(boolean includeNotifications) {
        if (this.actionItems == null) {
            this.actionItems = new LinkedHashSet<GrepExpressionItem>();
            if (this.statisticsExpressions != null) {
                this.actionItems.addAll(this.statisticsExpressions);
            }
            if (includeNotifications && this.notificationExpressions != null) {
                this.actionItems.addAll(this.notificationExpressions);
            }
            if (includeNotifications && this.errorLogExpressions != null) {
                this.actionItems.addAll(this.errorLogExpressions);
            }
        }
        return this.actionItems;
    }

    private void executeLink(LinkMatch linkMatch) {
        GrepLinkAdapter adapter = GrepLineStyleListener.createLinkAdapter(linkMatch, this.shell, this.project);
        adapter.openLink();
    }

    private void addLine(String text, boolean rewritten, GrepStyleRange[] ranges) {
        Line line = new Line(text, rewritten, ranges);
        this.lines.add(line);
        this.lineOffsets.add(this.charCount);
        this.originalOffsets.add(this.originalOffset);
        this.charCount += text.length() + this.delimiter.length();
        this.maxProcessedLineOffset = Math.max(this.maxProcessedLineOffset, this.originalOffset);
    }

    public LinkedList<Line> getLines() {
        return this.lines;
    }

    public void textChanging(TextChangingEvent event) {
        TextChangingEvent newEvent;
        boolean clear;
        boolean bl = clear = event.newCharCount == 0 && event.replaceCharCount == this.originalOffset;
        if (clear) {
            this.clear();
        }
        boolean bl2 = this.sentChanging = (newEvent = this.handleNewText(event.newText, true)) != null;
        if (!clear) {
            this.originalOffsetDelta += event.replaceCharCount;
        }
        if (clear) {
            for (TextChangeListener listener : this.listeners) {
                listener.textSet(new TextChangedEvent((StyledTextContent)this));
            }
        }
        if (this.sentChanging) {
            for (TextChangeListener listener : this.listeners) {
                listener.textChanging(newEvent);
            }
        }
    }

    public void textChanged(TextChangedEvent event) {
        if (this.sentChanging) {
            this.sentChanging = false;
            TextChangedEvent newEvent = new TextChangedEvent((StyledTextContent)this);
            for (TextChangeListener listener : this.listeners) {
                listener.textChanged(newEvent);
            }
        }
    }

    public void textSet(TextChangedEvent event) {
        this.refresh();
    }

    public int getCharCount() {
        return this.charCount;
    }

    public String getLine(int lineIndex) {
        if (lineIndex < 0 || lineIndex >= this.lines.size()) {
            return "";
        }
        Line line = this.lines.get(lineIndex);
        return line == null ? null : line.getText();
    }

    public Line getLineElement(int lineIndex) {
        if (lineIndex < 0 || lineIndex >= this.lines.size()) {
            return null;
        }
        return this.lines.get(lineIndex);
    }

    public int getLineAtOffset(int offset) {
        if (offset >= this.charCount) {
            return this.lines.size();
        }
        int i = this.lineOffsets.size() - 1;
        Iterator<Integer> itr = this.lineOffsets.descendingIterator();
        while (itr.hasNext()) {
            int lineOffset = itr.next();
            if (lineOffset <= offset) break;
            --i;
        }
        return i;
    }

    public int getLineCount() {
        return this.lines.size() + 1;
    }

    public String getLineDelimiter() {
        return this.delimiter;
    }

    public int getOffsetAtLine(int lineIndex) {
        if (lineIndex < 0) {
            return 0;
        }
        if (lineIndex >= this.lines.size()) {
            return this.charCount;
        }
        return this.lineOffsets.get(lineIndex);
    }

    public int getOriginalOffsetAtLine(int lineIndex) {
        if (this.lines.isEmpty()) {
            return -1;
        }
        if (lineIndex < 0) {
            return 0;
        }
        if (lineIndex >= this.lines.size()) {
            return this.originalOffsets.getLast() - this.originalOffsetDelta;
        }
        return this.originalOffsets.get(lineIndex) - this.originalOffsetDelta;
    }

    public String getTextRange(int start, int length) {
        if (length == 0) {
            return "";
        }
        int lineIndex = this.getLineAtOffset(start);
        int startLineOffset = this.lineOffsets.get(lineIndex);
        int remaining = length;
        StringBuilder sb = new StringBuilder();
        String s = this.lines.get(lineIndex).getText();
        s = s.substring(start - startLineOffset);
        sb.append(s);
        sb.append(this.delimiter);
        remaining -= s.length() + this.delimiter.length();
        while (remaining > 0) {
            if (++lineIndex >= this.lines.size()) break;
            s = this.lines.get(lineIndex).getText();
            sb.append(s);
            sb.append(this.delimiter);
            remaining -= s.length() + this.delimiter.length();
        }
        String range = sb.toString();
        if (range.length() > length) {
            range = range.substring(0, length);
        }
        return range;
    }

    public void replaceTextRange(int start, int replaceLength, String text) {
        Activator.getDefault().log(4, "Trying to modify filtered results.", null);
    }

    public void addTextChangeListener(TextChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeTextChangeListener(TextChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void participantAdded(GrepPageParticipant participant) {
    }

    @Override
    public void participantRemoved(GrepPageParticipant participant) {
    }

    @Override
    public void participantActivated(GrepPageParticipant participant) {
    }

    @Override
    public void settingsChanged() {
        this.matchLength = Activator.getDefault().getFilterMatchLength();
    }

    public GrepStyleRange[] getLineStyles(int lineIndex) {
        if (lineIndex < 0 || lineIndex >= this.lines.size()) {
            return null;
        }
        Line line = this.lines.get(lineIndex);
        return line == null ? null : line.getRanges();
    }

    public void setFilterExpressions(LinkedList<GrepExpressionItem> filterExpressions) {
        this.filterExpressions = filterExpressions;
        this.actionItems = null;
    }

    public void setStatisticsExpressions(LinkedHashSet<GrepExpressionItem> statisticsExpressions) {
        this.statisticsExpressions = statisticsExpressions;
        this.actionItems = null;
    }

    public void setNotificationExpressions(LinkedHashSet<GrepExpressionItem> notificationExpressions) {
        this.notificationExpressions = notificationExpressions;
        this.actionItems = null;
    }

    public void setErrorLogExpressions(LinkedHashSet<GrepExpressionItem> errorLogExpressions) {
        this.errorLogExpressions = errorLogExpressions;
        this.actionItems = null;
    }

    public void notificationClicked(Notification notification) {
        LinkMatch linkMatch = ((GrepConsoleNotification)notification).getLinkMatch();
        GrepExpressionItem item = linkMatch.getItem();
        if (item.getNotificationLink() != null) {
            LinkMatch popupLinkMatch = new LinkMatch(item, item.getNotificationLink(), linkMatch.getMatchResult(), linkMatch.getMatchStart(), linkMatch.getWholeLine(), linkMatch.getGroup(), linkMatch.getProject());
            this.executeLink(popupLinkMatch);
        } else {
            Shell shell = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            shell.forceActive();
        }
    }

    public void addStatisticsListener(IStatisticsListener listener) {
        this.statisticsListeners.add(listener);
    }

    public void removeStatisticsListener(IStatisticsListener listener) {
        this.statisticsListeners.remove(listener);
    }

    public void fireStatisticsRemoved(StatisticsEntry entry) {
        for (IStatisticsListener listener : this.statisticsListeners) {
            listener.statisticsRemoved(this, entry);
        }
    }

    public void fireStatisticsUpdated(StatisticsEntry entry, boolean isNew) {
        for (IStatisticsListener listener : this.statisticsListeners) {
            listener.statisticsUpdated(this, entry, isNew);
        }
    }

    public Collection<StatisticsEntry> getStatisticEntries() {
        return this.statisticEntries.values();
    }

    public static class Line {
        private String text;
        private boolean rewritten;
        private GrepStyleRange[] ranges;

        public Line(String text, boolean rewritten, GrepStyleRange[] ranges) {
            this.text = text;
            this.rewritten = rewritten;
            this.ranges = ranges;
        }

        public String getText() {
            return this.text;
        }

        public GrepStyleRange[] getRanges() {
            return this.ranges;
        }

        public boolean isRewritten() {
            return this.rewritten;
        }
    }
}

