/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters.links;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.links.GrepLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.links.CommandLink;
import name.schedenig.eclipse.grepconsole.util.RuntimeExecutor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CommandLinkAdapter
extends GrepLinkAdapter {
    private String command;
    private File workingDir;
    private String toolTipText;

    public CommandLinkAdapter(LinkMatch match, Shell shell) {
        super(match, shell);
    }

    private void init() {
        if (this.command != null || this.toolTipText != null) {
            return;
        }
        CommandLink link = this.getLink();
        this.command = this.replaceParams(link.getCommandPattern());
        String s = this.replaceParams(link.getWorkingDirPattern());
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        this.workingDir = s == null ? null : new File(s);
        this.toolTipText = this.command;
    }

    @Override
    public CommandLink getLink() {
        return (CommandLink)super.getLink();
    }

    @Override
    public void openLink() {
        this.init();
        RuntimeExecutor executor = new RuntimeExecutor(this.command, this.workingDir);
        try {
            executor.run();
        }
        catch (IOException ex) {
            Activator.getDefault().log(4, Messages.CommandLinkAdapter_could_not_execute_command, ex);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.CommandLinkAdapter_external_command_execution_failed, ex.getLocalizedMessage()));
        }
    }

    @Override
    public String getToolTipText() {
        this.init();
        return this.toolTipText;
    }
}

