/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters.links;

import java.io.File;
import java.text.MessageFormat;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.links.GrepLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.links.FileLink;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class FileLinkAdapter
extends GrepLinkAdapter {
    public static final String DEFAULT_BASE_DIR = "{eclipse:PROJECT_LOC}";
    private File file;
    private Integer lineNumber;
    private Integer offset;
    private String toolTipText;

    public FileLinkAdapter(LinkMatch match, Shell shell) {
        super(match, shell);
    }

    private void init() {
        if (this.file != null || this.toolTipText != null) {
            return;
        }
        FileLink link = this.getLink();
        String s = this.replaceParams(link.getFilePattern());
        s = this.stripUrl(s);
        this.file = new File(s);
        if (!this.file.isAbsolute() && !s.startsWith("file:/")) {
            s = link.getBaseDirPattern();
            s = s == null || s.trim().length() == 0 ? DEFAULT_BASE_DIR : s.trim();
            s = this.replaceParams(s);
            s = this.stripUrl(s);
            File baseDir = new File(s);
            this.file = new File(baseDir, this.file.getPath());
        }
        this.lineNumber = this.readOptionalIntPattern(link.getLineNumberPattern());
        this.offset = this.readOptionalIntPattern(link.getOffsetPattern());
        this.toolTipText = String.valueOf(this.file.toString()) + (this.lineNumber == null ? "" : " (" + this.lineNumber + ")");
    }

    private String stripUrl(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("file:") && (s = s.substring(5)).startsWith("///")) {
            s = s.substring(2);
        }
        return s;
    }

    @Override
    public FileLink getLink() {
        return (FileLink)super.getLink();
    }

    @Override
    public void openLink() {
        this.init();
        if (this.file.exists() && this.file.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(this.file.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                if (editor instanceof ITextEditor && this.lineNumber != null) {
                    GrepConsoleUtil.jumpToEditorLine((ITextEditor)editor, this.lineNumber, this.offset);
                }
                this.getShell().forceActive();
            }
            catch (PartInitException ex) {
                Activator.getDefault().log(4, Messages.FileLinkAdapter_could_not_open_editor, ex);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.FileLinkAdapter_could_not_open_editor_with_msg, ex.getLocalizedMessage()));
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.FileLinkAdapter_file_does_not_exist, this.file));
        }
    }

    @Override
    public String getToolTipText() {
        this.init();
        return this.toolTipText;
    }
}

