/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters.links;

import java.util.regex.MatchResult;
import name.schedenig.eclipse.grepconsole.adapters.GroupParameterResolver;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.model.links.IGrepLink;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import org.eclipse.swt.widgets.Shell;

public abstract class GrepLinkAdapter {
    public static final String PARAM_ECLIPSE_PREFIX = "eclipse:";
    public static final String PARAM_WHOLE_LINE = "line";
    public static final String PARAM_WHOLE_MATCH = "match";
    public static final String PARAM_GROUP_MATCH = "group";
    private Shell shell;
    private LinkMatch match;
    private GroupParameterResolver parameterResolver;

    public GrepLinkAdapter(LinkMatch match, Shell shell) {
        this.match = match;
        this.shell = shell;
    }

    public MatchResult getMatchResult() {
        return this.match.getMatchResult();
    }

    public IGrepLink getLink() {
        return this.match.getLink();
    }

    public LinkMatch getMatch() {
        return this.match;
    }

    public abstract void openLink();

    public abstract String getToolTipText();

    protected Shell getShell() {
        return this.shell;
    }

    protected String replaceParams(String pattern) {
        return GrepConsoleUtil.replaceParams(pattern, this.getMatch(), this.getParameterResolver());
    }

    private GrepConsoleUtil.IVariableResolver getParameterResolver() {
        if (this.parameterResolver == null) {
            this.parameterResolver = new GroupParameterResolver(this.match);
        }
        return this.parameterResolver;
    }

    protected Integer readOptionalIntPattern(String pattern) {
        if (pattern != null) {
            pattern = pattern.trim();
        }
        if (pattern == null || pattern.length() == 0) {
            return null;
        }
        try {
            return Integer.parseInt(this.replaceParams(pattern));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

