/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters.links;

import java.text.MessageFormat;
import java.util.regex.MatchResult;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.links.GrepLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.links.ScriptLink;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ScriptLinkAdapter
extends GrepLinkAdapter {
    public static final String PARAM_MATCH_RESULT = "matchResult";
    public static final String PARAM_GROUPS = "groups";
    public static final String PARAM_WHOLE_LINE = "wholeLine";
    public static final String PARAM_MATCHED_GROUP = "matchedGroup";

    public ScriptLinkAdapter(LinkMatch match, Shell shell) {
        super(match, shell);
    }

    @Override
    public ScriptLink getLink() {
        return (ScriptLink)super.getLink();
    }

    @Override
    public void openLink() {
        ScriptLink link = this.getLink();
        MatchResult matchResult = this.getMatchResult();
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName(link.getLanguage());
        if (engine == null) {
            Activator.getDefault().log(4, MessageFormat.format(Messages.ScriptLinkAdapter_unknown_script_language, link.getLanguage()), null);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.ScriptLinkAdapter_unknown_script_language, link.getLanguage()));
        }
        String[] groups = new String[matchResult.groupCount() + 1];
        int i = 0;
        while (i < groups.length) {
            groups[i] = matchResult.group(i);
            ++i;
        }
        engine.put(PARAM_MATCH_RESULT, matchResult);
        engine.put(PARAM_GROUPS, groups);
        engine.put(PARAM_WHOLE_LINE, this.getMatch().getWholeLine());
        engine.put(PARAM_MATCHED_GROUP, this.getMatch().getGroup());
        try {
            engine.eval(link.getCode());
        }
        catch (ScriptException ex) {
            Activator.getDefault().log(4, Messages.ScriptLinkAdapter_could_not_execute_script, ex);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.ScriptLinkAdapter_script_execution_failed, ex.getLocalizedMessage()));
        }
    }

    @Override
    public String getToolTipText() {
        return MessageFormat.format(Messages.ScriptLinkAdapter_language_script, this.getLink().getLanguage());
    }
}

