/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.adapters.links;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.links.GrepLinkAdapter;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.links.UrlLink;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class UrlLinkAdapter
extends GrepLinkAdapter {
    private URL url;
    private String toolTipText;

    public UrlLinkAdapter(LinkMatch match, Shell shell) {
        super(match, shell);
    }

    private void init() {
        if (this.url != null || this.toolTipText != null) {
            return;
        }
        String s = this.replaceParams(this.getLink().getUrlPattern());
        try {
            URI uri = new URI(s);
            if (!uri.isAbsolute()) {
                uri = new URI("http://" + s);
            }
            this.url = uri.toURL();
            this.toolTipText = String.valueOf(this.url.toString()) + (this.getLink().isExternal() ? Messages.UrlLinkAdapter_external : "");
        }
        catch (MalformedURLException malformedURLException) {
            this.url = null;
            this.toolTipText = String.valueOf(Messages.UrlLinkAdapter_invalid_url) + s;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.url = null;
            this.toolTipText = String.valueOf(Messages.UrlLinkAdapter_invalid_url) + s;
        }
    }

    @Override
    public UrlLink getLink() {
        return (UrlLink)super.getLink();
    }

    @Override
    public void openLink() {
        this.init();
        if (this.getLink().isExternal()) {
            try {
                Program.launch((String)this.url.toString());
            }
            catch (UnsatisfiedLinkError ex) {
                Activator.getDefault().log(4, Messages.UrlLinkAdapter_could_not_open_link, ex);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.UrlLinkAdapter_could_not_open_link_message, ex.getLocalizedMessage()));
            }
        } else {
            try {
                IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
                browser.openURL(this.url);
                this.getShell().forceActive();
            }
            catch (PartInitException ex) {
                Activator.getDefault().log(4, Messages.UrlLinkAdapter_could_not_open_link, ex);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.LinkAdapter_link_error, (String)MessageFormat.format(Messages.UrlLinkAdapter_could_not_open_link_message, ex.getLocalizedMessage()));
            }
        }
    }

    @Override
    public String getToolTipText() {
        this.init();
        return this.toolTipText;
    }
}

