/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.model;

import java.util.Set;
import java.util.UUID;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;

public abstract class AbstractGrepModelElement {
    private String id;
    private String name;
    private GrepExpressionFolder parent;
    private boolean defaultEnabled;
    private boolean defaultFilter;
    private boolean defaultStatistics;
    private boolean defaultNotifications;

    public AbstractGrepModelElement(String id) {
        this.id = id == null ? AbstractGrepModelElement.generateId() : id;
        this.defaultEnabled = true;
        this.defaultFilter = true;
        this.defaultStatistics = true;
        this.defaultNotifications = true;
    }

    protected AbstractGrepModelElement(AbstractGrepModelElement src, boolean identityCopy) {
        this.copyFrom(src, identityCopy);
    }

    public abstract AbstractGrepModelElement copy(boolean var1);

    protected void copyFrom(AbstractGrepModelElement src, boolean identityCopy) {
        this.id = identityCopy ? src.id : AbstractGrepModelElement.generateId();
        this.name = src.name;
        this.parent = src.parent;
        this.defaultEnabled = src.defaultEnabled;
        this.defaultFilter = src.defaultFilter;
        this.defaultStatistics = src.defaultStatistics;
        this.defaultNotifications = src.defaultNotifications;
    }

    private static String generateId() {
        return UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GrepExpressionFolder getParent() {
        return this.parent;
    }

    protected void setParent(GrepExpressionFolder parent) {
        this.parent = parent;
    }

    public GrepExpressionRootFolder getRoot() {
        AbstractGrepModelElement root = this;
        while (root != null && !(root instanceof GrepExpressionRootFolder)) {
            root = root.getParent();
        }
        return (GrepExpressionRootFolder)root;
    }

    public Set<String> getAllIds(Set<String> ids) {
        ids.add(this.id);
        return ids;
    }

    public void rewriteDuplicateIds(Set<String> excludeIds) {
        if (excludeIds.contains(this.id)) {
            this.id = AbstractGrepModelElement.generateId();
            excludeIds.add(this.id);
        }
    }

    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    public void setDefaultEnabled(boolean defaultEnabled) {
        this.defaultEnabled = defaultEnabled;
    }

    public boolean isDefaultFilter() {
        return this.defaultFilter;
    }

    public void setDefaultFilter(boolean defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

    public boolean isDefaultStatistics() {
        return this.defaultStatistics;
    }

    public void setDefaultStatistics(boolean defaultStatistics) {
        this.defaultStatistics = defaultStatistics;
    }

    public boolean isDefaultNotifications() {
        return this.defaultNotifications;
    }

    public void setDefaultNotifications(boolean defaultNotifications) {
        this.defaultNotifications = defaultNotifications;
    }

    public abstract void findStyleUses(GrepStyle var1, Set<GrepExpressionItem> var2);

    protected abstract void refreshStyles();
}

