/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;

public class GrepExpressionFolder
extends AbstractGrepModelElement {
    protected List<AbstractGrepModelElement> children;

    public GrepExpressionFolder() {
        this(null);
    }

    public GrepExpressionFolder(String id) {
        super(id);
        this.children = new LinkedList<AbstractGrepModelElement>();
    }

    public GrepExpressionFolder(GrepExpressionFolder src, boolean identityCopy) {
        super(src, identityCopy);
    }

    @Override
    public GrepExpressionFolder copy(boolean identityCopy) {
        return new GrepExpressionFolder(this, identityCopy);
    }

    @Override
    public void copyFrom(AbstractGrepModelElement src, boolean identityCopy) {
        super.copyFrom(src, identityCopy);
        this.children = new LinkedList<AbstractGrepModelElement>();
        for (AbstractGrepModelElement child : ((GrepExpressionFolder)src).children) {
            this.add(child.copy(identityCopy));
        }
    }

    public String toString() {
        return this.getName();
    }

    public void add(AbstractGrepModelElement element) {
        this.add(element, -1);
    }

    public void add(AbstractGrepModelElement element, int index) {
        if (element.getParent() != null) {
            element.getParent().remove(element);
        }
        if (index < 0) {
            index = this.children.size();
        } else if (index >= 0) {
            index = Math.min(index, this.children.size());
        }
        this.children.add(index, element);
        element.setParent(this);
    }

    public boolean remove(AbstractGrepModelElement element) {
        if (this.children.remove(element)) {
            element.setParent(null);
            return true;
        }
        return false;
    }

    public List<AbstractGrepModelElement> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public Set<String> getAllIds(Set<String> ids) {
        super.getAllIds(ids);
        for (AbstractGrepModelElement child : this.children) {
            child.getAllIds(ids);
        }
        return ids;
    }

    @Override
    public void rewriteDuplicateIds(Set<String> excludeIds) {
        super.rewriteDuplicateIds(excludeIds);
        for (AbstractGrepModelElement child : this.children) {
            child.rewriteDuplicateIds(excludeIds);
        }
    }

    public AbstractGrepModelElement findById(String id) {
        for (AbstractGrepModelElement child : this.children) {
            AbstractGrepModelElement found;
            if (id.equals(child.getId())) {
                return child;
            }
            if (!(child instanceof GrepExpressionFolder) || (found = ((GrepExpressionFolder)child).findById(id)) == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public void findStyleUses(GrepStyle style, Set<GrepExpressionItem> items) {
        for (AbstractGrepModelElement child : this.getChildren()) {
            child.findStyleUses(style, items);
        }
    }

    @Override
    protected void refreshStyles() {
        for (AbstractGrepModelElement child : this.children) {
            child.refreshStyles();
        }
    }
}

