/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.model;

import java.util.Map;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;

public abstract class InheritedFlagResolver {
    public static final InheritedFlagResolver ENABLED_RESOLVER = new InheritedFlagResolver(){

        @Override
        protected boolean getDefaultValue(AbstractGrepModelElement element) {
            return element.isDefaultEnabled();
        }
    };
    public static final InheritedFlagResolver FILTER_RESOLVER = new InheritedFlagResolver(){

        @Override
        protected boolean getDefaultValue(AbstractGrepModelElement element) {
            return element.isDefaultFilter();
        }
    };
    public static final InheritedFlagResolver STATISTICS_RESOLVER = new InheritedFlagResolver(){

        @Override
        protected boolean getDefaultValue(AbstractGrepModelElement element) {
            return element.isDefaultStatistics();
        }
    };
    public static final InheritedFlagResolver NOTIFICATIONS_RESOLVER = new InheritedFlagResolver(){

        @Override
        protected boolean getDefaultValue(AbstractGrepModelElement element) {
            return element.isDefaultNotifications();
        }
    };

    public InheritedFlag getFlag(AbstractGrepModelElement element, Map<String, Boolean> inheritanceMap) {
        boolean greyed;
        Boolean checked = inheritanceMap == null ? Boolean.valueOf(this.getDefaultValue(element)) : inheritanceMap.get(element.getId());
        boolean bl = greyed = !this.isElementSet(element.getParent(), inheritanceMap);
        if (checked == null) {
            Boolean inheritedChecked = this.getDefaultValue(element);
            if (inheritedChecked == null) {
                inheritedChecked = false;
            }
            return new InheritedFlag(inheritedChecked, true, greyed);
        }
        return new InheritedFlag(checked, false, greyed);
    }

    private boolean isElementSet(AbstractGrepModelElement element, Map<String, Boolean> inheritanceMap) {
        GrepExpressionFolder parent = element.getParent();
        if (parent != null && !this.isElementSet(element.getParent(), inheritanceMap)) {
            return false;
        }
        Boolean enabled = inheritanceMap == null ? null : inheritanceMap.get(element.getId());
        if (enabled == null) {
            enabled = this.getDefaultValue(element);
        }
        return enabled;
    }

    protected abstract boolean getDefaultValue(AbstractGrepModelElement var1);

    public static class InheritedFlag {
        private boolean set;
        private boolean inherited;
        private boolean greyed;

        private InheritedFlag(boolean set, boolean inherited, boolean greyed) {
            this.set = set;
            this.inherited = inherited;
            this.greyed = greyed;
        }

        public boolean isSet() {
            return this.set;
        }

        public boolean isInherited() {
            return this.inherited;
        }

        public boolean isGreyed() {
            return this.greyed;
        }
    }
}

