/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.model.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.model.xml.XmlHandlerException;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LegacyXmlReader {
    private static final String XML_EXPRESSIONS = "expressions";
    private static final String XML_EXPRESSION = "expression";
    private static final String XML_NAME = "name";
    private static final String XML_GREP_EXPRESSION = "grepExpression";
    private static final String XML_ENABLED = "enabled";
    private static final String XML_STYLE = "style";
    private static final String XML_BOLD = "bold";
    private static final String XML_ITALIC = "italic";
    private static final String XML_FOREGROUND = "foreground";
    private static final String XML_BACKGROUND = "background";
    private static final String XML_UNDERLINE = "underline";
    private static final String XML_UNDERLINE_COLOR = "underlineColor";
    private static final String XML_STRIKEOUT = "strikeout";
    private static final String XML_STRIKEOUT_COLOR = "strikeoutColor";
    private static final String XML_BORDER = "border";
    private static final String XML_BORDER_COLOR = "borderColor";

    public GrepExpressionRootFolder xmlStringToExpressions(String xml) throws XmlHandlerException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xml)));
            return this.documentToExpressions(doc);
        }
        catch (ParserConfigurationException ex) {
            throw new XmlHandlerException(ex);
        }
        catch (SAXException ex) {
            throw new XmlHandlerException(ex);
        }
        catch (IOException ex) {
            throw new XmlHandlerException(ex);
        }
    }

    private GrepExpressionRootFolder documentToExpressions(Document doc) {
        GrepExpressionRootFolder root = new GrepExpressionRootFolder();
        GrepExpressionFolder collection = new GrepExpressionFolder();
        collection.setName(Messages.LegacyXmlReader_imported);
        root.add(collection);
        Node xmlRoot = doc.getChildNodes().item(0);
        if (XML_EXPRESSIONS.equals(xmlRoot.getNodeName())) {
            this.readExpressions((Element)xmlRoot, collection);
        }
        return root;
    }

    private void readExpressions(Element root, GrepExpressionFolder collection) {
        NodeList children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && XML_EXPRESSION.equals(child.getNodeName())) {
                collection.add(this.readExpression((Element)child, collection.getRoot()));
            }
            ++i;
        }
    }

    private GrepExpressionItem readExpression(Element element, GrepExpressionRootFolder root) {
        String s;
        GrepExpressionItem item = new GrepExpressionItem();
        Boolean b = LegacyXmlReader.readBooleanAttribute(element, XML_ENABLED);
        if (b == null || b.booleanValue()) {
            item.setDefaultEnabled(true);
        }
        if ((s = element.getAttribute(XML_NAME)) != null && s.length() > 0) {
            item.setName(s);
        }
        if ((s = element.getAttribute(XML_GREP_EXPRESSION)) != null && s.length() > 0) {
            item.setGrepExpression(s);
        }
        ArrayList<GrepGroup> groups = new ArrayList<GrepGroup>();
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && XML_STYLE.equals(child.getNodeName())) {
                GrepStyle style = this.readStyle((Element)child);
                root.addStyle(style);
                GrepGroup group = new GrepGroup();
                group.setStyle(style);
                groups.add(group);
            }
            ++i;
        }
        item.setGroups(groups.toArray(new GrepGroup[0]));
        return item;
    }

    private GrepStyle readStyle(Element element) {
        GrepStyle style = new GrepStyle();
        Boolean b = LegacyXmlReader.readBooleanAttribute(element, XML_BOLD);
        style.setBold(b != null && b != false);
        b = LegacyXmlReader.readBooleanAttribute(element, XML_ITALIC);
        style.setItalic(b != null && b != false);
        String s = element.getAttribute(XML_FOREGROUND);
        if (s != null && s.length() > 0) {
            style.setForeground(GrepConsoleUtil.stringToRgb(s));
        }
        if ((s = element.getAttribute(XML_BACKGROUND)) != null && s.length() > 0) {
            style.setBackground(GrepConsoleUtil.stringToRgb(s));
        }
        if ((b = LegacyXmlReader.readBooleanAttribute(element, XML_UNDERLINE)) != null) {
            style.setUnderline(b);
        }
        if ((s = element.getAttribute(XML_UNDERLINE_COLOR)) != null && s.length() > 0) {
            style.setUnderlineColor(GrepConsoleUtil.stringToRgb(s));
        }
        if ((b = LegacyXmlReader.readBooleanAttribute(element, XML_STRIKEOUT)) != null) {
            style.setStrikeout(b);
        }
        if ((s = element.getAttribute(XML_STRIKEOUT_COLOR)) != null && s.length() > 0) {
            style.setStrikeoutColor(GrepConsoleUtil.stringToRgb(s));
        }
        if ((b = LegacyXmlReader.readBooleanAttribute(element, XML_BORDER)) != null) {
            style.setBorder(b);
        }
        if ((s = element.getAttribute(XML_BORDER_COLOR)) != null && s.length() > 0) {
            style.setBorderColor(GrepConsoleUtil.stringToRgb(s));
        }
        return style;
    }

    private static Boolean readBooleanAttribute(Element element, String attribute) {
        String s = element.getAttribute(attribute);
        if (s == null || s.length() == 0) {
            return null;
        }
        return Boolean.parseBoolean(s);
    }
}

