/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.MatchResult;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.adapters.links.LinkMatch;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public class GrepConsoleUtil {
    public static final String ATTRIBUTE_PREFIX = "name.schedenig.eclipse.grepconsole.";
    public static final String ATTRIBUTE_ENABLED_IDS = "name.schedenig.eclipse.grepconsole.EnabledIds";
    public static final String ATTRIBUTE_DISABLED_IDS = "name.schedenig.eclipse.grepconsole.DisabledIds";
    public static final String ATTRIBUTE_FILTER_ENABLED_IDS = "name.schedenig.eclipse.grepconsole.FilterEnabledIds";
    public static final String ATTRIBUTE_FILTER_DISABLED_IDS = "name.schedenig.eclipse.grepconsole.FilterDisabledIds";
    public static final String ATTRIBUTE_STATISTICS_ENABLED_IDS = "name.schedenig.eclipse.grepconsole.StatisticsEnabledIds";
    public static final String ATTRIBUTE_STATISTICS_DISABLED_IDS = "name.schedenig.eclipse.grepconsole.StatisticsDisabledIds";
    public static final String ATTRIBUTE_NOTIFICATIONS_ENABLED_IDS = "name.schedenig.eclipse.grepconsole.NotificationsEnabledIds";
    public static final String ATTRIBUTE_NOTIFICATIONS_DISABLED_IDS = "name.schedenig.eclipse.grepconsole.NotificationsDisabledIds";
    public static final String PREF_DEBUG_CONSOLE_BACKGROUND_COLOR = "org.eclipse.debug.ui.consoleBackground";
    public static final String PREF_DEBUG_CONSOLE_SYS_OUT_COLOR = "org.eclipse.debug.ui.outColor";
    private static Random random = new Random();

    public static String intHexString(int value, int length) {
        String hex = Integer.toHexString(value);
        if (hex.length() < length) {
            StringBuffer sb = new StringBuffer("0");
            int i = sb.length() + hex.length();
            while (i < length) {
                sb.append('0');
                ++i;
            }
            sb.append(hex);
            hex = sb.toString();
        }
        return hex;
    }

    public static RGB getRandomRgb() {
        return new RGB(128 + random.nextInt(128), 128 + random.nextInt(128), 128 + random.nextInt(128));
    }

    public static String rgbToString(RGB color) {
        if (color == null) {
            return "";
        }
        return String.valueOf(GrepConsoleUtil.intHexString(color.red, 2)) + GrepConsoleUtil.intHexString(color.green, 2) + GrepConsoleUtil.intHexString(color.blue, 2);
    }

    public static RGB stringToRgb(String s) throws NumberFormatException {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.length() != 6) {
            s = "000000" + s;
            s = s.substring(s.length() - 6);
        }
        return new RGB(Integer.parseInt(s.substring(0, 2), 16), Integer.parseInt(s.substring(2, 4), 16), Integer.parseInt(s.substring(4, 6), 16));
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static void convertIdBooleanToSets(Map<String, Boolean> map, Set<String> trueSet, Set<String> falseSet) {
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            Boolean b = entry.getValue();
            if (b == null) continue;
            if (b.booleanValue()) {
                trueSet.add(entry.getKey());
                continue;
            }
            falseSet.add(entry.getKey());
        }
    }

    public static Map<String, Boolean> convertIdBooleanMapFromSets(Set<String> trueSet, Set<String> falseSet) {
        HashMap<String, Boolean> enablementMap = new HashMap<String, Boolean>();
        for (String id : trueSet) {
            enablementMap.put(id, true);
        }
        for (String id : falseSet) {
            enablementMap.put(id, false);
        }
        return enablementMap;
    }

    public static void storeIdBooleanMap(String attributeNameTrue, String attributeNameFalse, Map<String, Boolean> map, ILaunchConfigurationWorkingCopy configuration) {
        HashSet<String> enabledIds = new HashSet<String>();
        HashSet<String> disabledIds = new HashSet<String>();
        GrepConsoleUtil.convertIdBooleanToSets(map, enabledIds, disabledIds);
        configuration.setAttribute(attributeNameTrue, enabledIds);
        configuration.setAttribute(attributeNameFalse, disabledIds);
    }

    public static Map<String, Boolean> loadIdBooleanMap(String attributeNameTrue, String attributeNameFalse, ILaunchConfiguration configuration) throws CoreException {
        Set enabledIds = configuration.getAttribute(attributeNameTrue, new HashSet());
        Set disabledIds = configuration.getAttribute(attributeNameFalse, new HashSet());
        return GrepConsoleUtil.convertIdBooleanMapFromSets(enabledIds, disabledIds);
    }

    public static void addActionToMenu(Menu menu, IAction action) {
        ActionContributionItem aci = new ActionContributionItem(action);
        aci.fill(menu, -1);
    }

    public static String readText(InputStream in) throws IOException {
        String s;
        StringBuilder sb = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((s = reader.readLine()) != null) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append("\n");
            }
            sb.append(s);
        }
        return sb == null ? null : sb.toString();
    }

    public static Point charsToPixelDimensions(Drawable device, int charsWidth, int charsHeight) {
        GC gc = new GC(device);
        try {
            FontMetrics fm = gc.getFontMetrics();
            int ch = fm.getHeight();
            int cw = fm.getAverageCharWidth();
            Point point = new Point(cw * charsWidth, ch * charsHeight);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    public static void jumpToEditorLine(ITextEditor editor, Integer lineNumber, Integer offset) {
        ITextEditor textEditor = editor;
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        if (document != null) {
            IRegion lineInfo = null;
            try {
                lineInfo = document.getLineInformation(lineNumber - 1);
            }
            catch (BadLocationException badLocationException) {}
            if (lineInfo != null) {
                textEditor.selectAndReveal(lineInfo.getOffset() + (offset == null ? 0 : offset), offset == null ? lineInfo.getLength() : 0);
            }
        }
    }

    public static String replaceParams(String s, MatchResult matchResult, String wholeLine, int group, List<int[]> groupRanges, IProject project, IVariableResolver variableResolver) {
        if (s == null) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder expression = null;
        boolean escape = false;
        Integer currentGroupStart = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (expression != null) {
                if (c == '}') {
                    String param = expression.toString();
                    String replace = null;
                    if (variableResolver != null) {
                        replace = variableResolver.getValue(param);
                    }
                    if (replace == null) {
                        if (param.startsWith("eclipse:")) {
                            IPathVariableManager pvm;
                            URI uri = null;
                            if (project != null && (pvm = project.getPathVariableManager()) != null) {
                                String name = param.substring("eclipse:".length());
                                uri = pvm.getURIValue(name);
                            }
                            if (uri != null) {
                                replace = uri.toString();
                            }
                        } else if ("line".equals(param)) {
                            replace = wholeLine;
                        } else if ("match".equals(param)) {
                            replace = matchResult.group();
                        } else if ("group".equals(param)) {
                            if (group >= 0) {
                                replace = matchResult.group(group);
                            }
                        } else {
                            try {
                                replace = matchResult.group(Integer.parseInt(param));
                            }
                            catch (NumberFormatException ex) {
                                Activator.getDefault().log(2, MessageFormat.format(Messages.GrepLinkAdapter_could_not_resolve_parameter, param), ex);
                                replace = "{" + param + "}";
                            }
                        }
                    }
                    if (replace == null) {
                        replace = "{" + param + "}";
                    }
                    sb.append(replace);
                    expression = null;
                } else {
                    expression.append(c);
                }
            } else if (escape) {
                switch (c) {
                    case '(': 
                    case ')': 
                    case '\\': 
                    case '{': 
                    case '}': {
                        sb.append(c);
                        break;
                    }
                    default: {
                        sb.append("\\" + c);
                    }
                }
                escape = false;
            } else if (c == '\\') {
                escape = true;
            } else if (groupRanges != null && c == '(' && currentGroupStart == null) {
                currentGroupStart = sb.length();
            } else if (groupRanges != null && c == ')' && currentGroupStart != null) {
                groupRanges.add(new int[]{currentGroupStart, sb.length() - 1});
                currentGroupStart = null;
            } else if (c == '{') {
                expression = new StringBuilder();
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (escape) {
            if (expression != null) {
                expression.append('\\');
            } else {
                sb.append('\\');
            }
        }
        if (expression != null) {
            sb.append(expression.toString());
        }
        return sb.toString();
    }

    public static String replaceParams(String s, LinkMatch match, IVariableResolver variableResolver) {
        return GrepConsoleUtil.replaceParams(s, match.getMatchResult(), match.getWholeLine(), match.getGroup(), null, match.getProject(), variableResolver);
    }

    public static int countGroups(String s) {
        if (s == null) {
            return 0;
        }
        boolean inExpression = false;
        boolean escape = false;
        boolean inGroup = false;
        int groupCount = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (inExpression) {
                if (c == '}') {
                    inExpression = false;
                }
            } else if (escape) {
                escape = false;
            } else if (c == '\\') {
                escape = true;
            } else if (c == '(' && !inGroup) {
                inGroup = true;
            } else if (c == ')' && inGroup) {
                inGroup = false;
                ++groupCount;
            } else if (c == '{') {
                inExpression = true;
            }
            ++i;
        }
        return groupCount;
    }

    public static ScopedPreferenceStore getDebugUiPreferences() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.debug.ui");
    }

    public static RGB getPreferenceColor(IPreferenceStore prefs, String key) {
        int b;
        int g;
        int r;
        if (prefs == null || !prefs.contains(key)) {
            return null;
        }
        String s = prefs.getString(key).trim();
        if (s.length() == 0) {
            return null;
        }
        String[] values = s.split("\\,");
        if (values.length != 3) {
            Activator.getDefault().log(2, MessageFormat.format("Cannot parse preference value for {0}: {1}", key, s), null);
            return null;
        }
        try {
            r = Integer.parseInt(values[0]);
            g = Integer.parseInt(values[1]);
            b = Integer.parseInt(values[2]);
        }
        catch (NumberFormatException ex) {
            Activator.getDefault().log(2, MessageFormat.format("Cannot parse preference value for {0}: {1}", key, s), ex);
            return null;
        }
        return new RGB(r, g, b);
    }

    public static final RGB getConsoleBackgroundColor() {
        return GrepConsoleUtil.getPreferenceColor((IPreferenceStore)GrepConsoleUtil.getDebugUiPreferences(), PREF_DEBUG_CONSOLE_BACKGROUND_COLOR);
    }

    public static final RGB getConsoleTextColor() {
        return GrepConsoleUtil.getPreferenceColor((IPreferenceStore)GrepConsoleUtil.getDebugUiPreferences(), PREF_DEBUG_CONSOLE_SYS_OUT_COLOR);
    }

    public static final RGB getGrepViewBackgroundColor() {
        String s = Activator.getDefault().getPreferenceStore().getString("grepViewBackgroundColor");
        if (s == null || s.length() == 0) {
            return GrepConsoleUtil.getConsoleBackgroundColor();
        }
        return GrepConsoleUtil.stringToRgb(s);
    }

    public static final RGB getGrepViewTextColor() {
        String s = Activator.getDefault().getPreferenceStore().getString("grepViewForegroundColor");
        if (s == null || s.length() == 0) {
            return GrepConsoleUtil.getConsoleTextColor();
        }
        return GrepConsoleUtil.stringToRgb(s);
    }

    public static final RGB getNotificationForegroundColor() {
        String s = Activator.getDefault().getPreferenceStore().getString("notificationForegroundColor");
        if (s == null || s.length() == 0) {
            return null;
        }
        return GrepConsoleUtil.stringToRgb(s);
    }

    public static final RGB getNotificationBackgroundColor() {
        String s = Activator.getDefault().getPreferenceStore().getString("notificationBackgroundColor");
        if (s == null || s.length() == 0) {
            return null;
        }
        return GrepConsoleUtil.stringToRgb(s);
    }

    public static Label createPreferenceLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        GridData data = new GridData(4, 0x1000000, false, false, 3, 1);
        data.verticalIndent = GrepConsoleUtil.charsToPixelDimensions((Drawable)parent.getDisplay(), (int)1, (int)1).y;
        label.setLayoutData((Object)data);
        return label;
    }

    public static interface IVariableResolver {
        public String getValue(String var1);
    }
}

