/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DefaultSizeTitleAreaDialog
extends TitleAreaDialog {
    public static final String DIALOG_FONT_DATA = "DIALOG_FONT_NAME";
    public static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    public static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";

    public DefaultSizeTitleAreaDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        Label imageLabel = this.getTitleImageLabel();
        FormData formData = (FormData)imageLabel.getLayoutData();
        formData.right.offset = -4;
        Dialog.applyDialogFont((Control)parent);
        return contents;
    }

    protected Point getInitialSize() {
        IDialogSettings settings;
        Point result = this.getDefaultSize();
        if ((this.getDialogBoundsStrategy() & 2) != 0 && (settings = this.getDialogBoundsSettings()) != null) {
            FontData[] fontDatas;
            boolean useStoredBounds = true;
            String previousDialogFontData = settings.get(DIALOG_FONT_DATA);
            if (previousDialogFontData != null && previousDialogFontData.length() > 0 && (fontDatas = JFaceResources.getDialogFont().getFontData()).length > 0) {
                String currentDialogFontData = fontDatas[0].toString();
                useStoredBounds = currentDialogFontData.equalsIgnoreCase(previousDialogFontData);
            }
            if (useStoredBounds) {
                try {
                    int width = settings.getInt(DIALOG_WIDTH);
                    int height = settings.getInt(DIALOG_HEIGHT);
                    if (width != -1) {
                        result.x = width;
                    }
                    if (height != -1) {
                        result.y = height;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return result;
    }

    protected Point getDefaultSize() {
        return this.getShell().computeSize(-1, -1, true);
    }
}

