/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.common;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;

public class CharacterMarginPainter
implements PaintListener {
    private List<Margin> margins = new LinkedList<Margin>();

    public CharacterMarginPainter(Control control) {
        control.addPaintListener((PaintListener)this);
    }

    public void addMargin(Margin margin) {
        this.margins.add(margin);
    }

    public void addMargin(int x, Color color) {
        this.margins.add(new Margin(x, color));
    }

    public void clearMargins() {
        this.margins.clear();
    }

    public List<Margin> getMargins() {
        return Collections.unmodifiableList(this.margins);
    }

    public void paintControl(PaintEvent e) {
        StyledText st = (StyledText)e.widget;
        int offset = st.getHorizontalPixel();
        GC gc = e.gc;
        Color backupColor = null;
        int charWidth = gc.getFontMetrics().getAverageCharWidth();
        for (Margin margin : this.margins) {
            int x = margin.getX() * charWidth - offset;
            if (backupColor == null) {
                backupColor = gc.getForeground();
            }
            gc.setForeground(margin.getColor());
            gc.drawLine(x, e.y, x, e.y + e.height);
        }
        if (backupColor != null) {
            gc.setForeground(backupColor);
        }
    }

    public static class Margin {
        private int x;
        private Color color;

        public Margin(int x, Color color) {
            this.x = x;
            this.color = color;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }
}

