/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import java.util.Map;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.AbstractGrepModelElement;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionFolder;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionsWithSelection;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.model.InheritedFlagResolver;
import name.schedenig.eclipse.grepconsole.view.colors.ColorRegistry;
import name.schedenig.eclipse.grepconsole.view.items.StyleImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class ItemLabelProvider
extends OwnerDrawLabelProvider
implements ILabelProvider {
    private static final int SPACE = 4;
    private static final RGB RGB_DISABLED = new RGB(160, 160, 160);
    private ColumnViewer viewer;
    private StyleImageRegistry styleImageRegistry = new StyleImageRegistry();
    private ColorRegistry colorRegistry = new ColorRegistry(Activator.getDefault().getColorRegistry());

    public void dispose() {
        super.dispose();
        this.styleImageRegistry.dispose();
        this.colorRegistry.disposeColors();
    }

    protected void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        this.viewer = viewer;
    }

    public String getText(Object element) {
        AbstractGrepModelElement grepElement = (AbstractGrepModelElement)element;
        String text = null;
        if (grepElement instanceof GrepExpressionItem && grepElement.getName() == null) {
            text = ((GrepExpressionItem)grepElement).getGrepExpression();
        }
        if (text == null) {
            text = grepElement.getName();
        }
        return text == null ? "" : text;
    }

    public Font getFont(Object element) {
        if (element instanceof GrepExpressionFolder) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        }
        return JFaceResources.getDialogFont();
    }

    public Image getImage(Object element) {
        if (!(element instanceof GrepExpressionItem)) {
            return null;
        }
        GrepExpressionItem item = (GrepExpressionItem)element;
        if (item.getGroups() == null || item.getGroups().length == 0) {
            return null;
        }
        GrepStyle style = null;
        GrepGroup[] grepGroupArray = item.getGroups();
        int n = grepGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            GrepGroup g = grepGroupArray[n2];
            GrepStyle s = g.getStyle();
            if (s != null) {
                style = s;
                break;
            }
            ++n2;
        }
        RGB foreground = style == null ? null : style.getForeground();
        RGB background = style == null ? null : style.getBackground();
        return this.styleImageRegistry.getColorImage(new StyleImageRegistry.RgbPair(foreground, background));
    }

    protected void measure(Event event, Object element) {
        GC gc = event.gc;
        Image image = this.getImage(element);
        String text = this.getText(element);
        Font oldFont = gc.getFont();
        Font font = this.getFont(element);
        if (font == null) {
            font = JFaceResources.getFont((String)"org.eclipse.jface.defaultfont");
        }
        gc.setFont(font);
        Point size = gc.textExtent(text);
        gc.setFont(oldFont);
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            size.x += imageBounds.width + 4;
            size.y = Math.max(size.y, imageBounds.height);
        }
        event.setBounds(new Rectangle(event.x, event.y, size.x, size.y));
    }

    protected void erase(Event event, Object element) {
    }

    protected void paint(Event event, Object element) {
        Color color;
        boolean selected;
        Image image = this.getImage(element);
        String text = this.getText(element);
        boolean enabled = this.isElementEnabled((AbstractGrepModelElement)element);
        boolean bl = selected = (event.detail & 2) != 0;
        if (enabled) {
            Display display = this.viewer.getControl().getDisplay();
            color = selected ? display.getSystemColor(27) : display.getSystemColor(24);
        } else {
            color = this.colorRegistry.get(RGB_DISABLED);
        }
        int x = event.x;
        if (image != null) {
            Rectangle imageBounds = image.getBounds();
            event.gc.drawImage(image, event.x, event.y + (event.height - imageBounds.height) / 2);
            int imageWidth = imageBounds.width + 4;
            x += imageWidth;
        }
        Device device = event.gc.getDevice();
        TextLayout layout = new TextLayout(device);
        try {
            Font font = this.getFont(element);
            if (font == null) {
                font = JFaceResources.getFont((String)"org.eclipse.jface.defaultfont");
            }
            TextStyle style = new TextStyle(font, color, null);
            layout.setText(text);
            layout.setStyle(style, 0, text.length());
            layout.draw(event.gc, x, event.y + (event.height - layout.getBounds().height) / 2);
        }
        finally {
            layout.dispose();
        }
    }

    public boolean isElementEnabled(AbstractGrepModelElement element) {
        GrepExpressionFolder parent = element.getParent();
        if (parent != null && !this.isElementEnabled(element.getParent())) {
            return false;
        }
        Map<String, Boolean> enablementMap = this.getEnablementMap();
        Boolean enabled = enablementMap == null ? null : enablementMap.get(element.getId());
        if (enabled == null) {
            enabled = element.isDefaultEnabled();
        }
        return enabled;
    }

    private Map<String, Boolean> getEnablementMap() {
        Object input = this.viewer.getInput();
        if (input instanceof GrepExpressionsWithSelection) {
            return ((GrepExpressionsWithSelection)this.viewer.getInput()).getEnablementMap();
        }
        return null;
    }

    private Map<String, Boolean> getFilterMap() {
        Object input = this.viewer.getInput();
        if (input instanceof GrepExpressionsWithSelection) {
            return ((GrepExpressionsWithSelection)this.viewer.getInput()).getFilterMap();
        }
        return null;
    }

    private Map<String, Boolean> getStatisticsMap() {
        Object input = this.viewer.getInput();
        if (input instanceof GrepExpressionsWithSelection) {
            return ((GrepExpressionsWithSelection)this.viewer.getInput()).getStatisticsMap();
        }
        return null;
    }

    private Map<String, Boolean> getNotificationsMap() {
        Object input = this.viewer.getInput();
        if (input instanceof GrepExpressionsWithSelection) {
            return ((GrepExpressionsWithSelection)this.viewer.getInput()).getNotificationsMap();
        }
        return null;
    }

    public String getToolTipText(Object element) {
        String name = this.getText(element);
        AbstractGrepModelElement me = (AbstractGrepModelElement)element;
        InheritedFlagResolver.InheritedFlag enabled = InheritedFlagResolver.ENABLED_RESOLVER.getFlag(me, this.getEnablementMap());
        InheritedFlagResolver.InheritedFlag filtered = InheritedFlagResolver.FILTER_RESOLVER.getFlag(me, this.getFilterMap());
        InheritedFlagResolver.InheritedFlag statistics = InheritedFlagResolver.STATISTICS_RESOLVER.getFlag(me, this.getStatisticsMap());
        InheritedFlagResolver.InheritedFlag notifications = InheritedFlagResolver.NOTIFICATIONS_RESOLVER.getFlag(me, this.getNotificationsMap());
        String enabledText = String.valueOf(enabled.isSet() ? Messages.ItemLabelProvider_styled : Messages.ItemLabelProvider_unstyled) + (enabled.isInherited() ? " " + Messages.ItemLabelProvider_inherited : "");
        String filteredText = String.valueOf(filtered.isSet() ? Messages.ItemLabelProvider_filtered : Messages.ItemLabelProvider_unfiltered) + (filtered.isInherited() ? " " + Messages.ItemLabelProvider_inherited : "");
        String statisticsText = String.valueOf(statistics.isSet() ? Messages.ItemLabelProvider_statistics : Messages.ItemLabelProvider_no_statistics) + (filtered.isInherited() ? " " + Messages.ItemLabelProvider_inherited : "");
        String notificationsText = String.valueOf(notifications.isSet() ? Messages.ItemLabelProvider_notifications : Messages.ItemLabelProvider_no_notifications) + (notifications.isInherited() ? " " + Messages.ItemLabelProvider_inherited : "");
        String s = String.valueOf(name) + " - " + enabledText + ", " + filteredText + ", " + statisticsText + "," + notificationsText + ".";
        return s;
    }
}

