/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import java.util.LinkedList;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class LineLengthChecker {
    public static final String LABEL_TEXT = Messages.LineLengthChecker_length_limits_exceeded;
    public static final String MESSAGE_STYLE_LENGTH_LIMIT_EXCEEDED = Messages.LineLengthChecker_style_length_limit_n_exceeded;
    public static final String MESSAGE_FILTER_LENGTH_LIMIT_EXCEEDED = Messages.LineLengthChecker_filter_length_limit_n_exceeded;
    public static final String MESSAGE_PREVIEW_TOOLTIP = Messages.LineLengthChecker_style_length_limit_m_filter_length_limit_m;
    private StyledText styledText;
    private int styleMatchLength;
    private int filterMatchLength;
    private LinkedList<Listener> listeners = new LinkedList();
    private boolean styleExceeded;
    private boolean filterExceeded;

    public LineLengthChecker(StyledText styledText) {
        this.styledText = styledText;
        styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LineLengthChecker.this.textModified();
            }
        });
        this.refreshLengths();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected void doExceedsChanged() {
        for (Listener listener : this.listeners) {
            listener.exceedsChanged();
        }
    }

    public void refreshLengths() {
        Activator activator = Activator.getDefault();
        this.styleMatchLength = activator.getStyleMatchLength();
        this.filterMatchLength = activator.getFilterMatchLength();
    }

    protected void textModified() {
        boolean newStyleExceeded = false;
        boolean newFilterExceeded = false;
        int i = 0;
        while (i < this.styledText.getLineCount()) {
            String text = this.styledText.getLine(i);
            int l = text.length();
            if ((newStyleExceeded |= l > this.styleMatchLength) && (newFilterExceeded |= l > this.filterMatchLength)) break;
            ++i;
        }
        if (newStyleExceeded != this.styleExceeded || newFilterExceeded != this.filterExceeded) {
            this.styleExceeded = newStyleExceeded;
            this.filterExceeded = newFilterExceeded;
            this.doExceedsChanged();
        }
    }

    public boolean isStyleExceeded() {
        return this.styleExceeded;
    }

    public boolean isFilterExceeded() {
        return this.filterExceeded;
    }

    public int getStyleMatchLength() {
        return this.styleMatchLength;
    }

    public int getFilterMatchLength() {
        return this.filterMatchLength;
    }

    public static interface Listener {
        public void exceedsChanged();
    }
}

