/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.items;

import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.view.colors.ColorRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PreviewColorHandler
implements IPropertyChangeListener {
    public static final String PREF_PREVIEW_COLORS = "previewColors";
    private Control control;
    private ColorChoice choice = ColorChoice.CONSOLE;
    private ColorRegistry colorRegistry;
    private Menu parentMenu;
    private MenuItem miConsole;
    private MenuItem miGrepView;

    public PreviewColorHandler(Control control) {
        this(control, null);
    }

    public PreviewColorHandler(Control control, Menu parentMenu) {
        this.control = control;
        this.parentMenu = parentMenu;
        this.init();
    }

    private void init() {
        Menu menu;
        final IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        this.colorRegistry = new ColorRegistry(Activator.getDefault().getColorRegistry());
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                prefStore.removePropertyChangeListener((IPropertyChangeListener)PreviewColorHandler.this);
                PreviewColorHandler.this.colorRegistry.disposeColors();
            }
        });
        prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.parentMenu != null) {
            MenuItem miColors = new MenuItem(this.parentMenu, 64);
            miColors.setText(Messages.PreviewColorHandler_menu_colors);
            menu = new Menu((Decorations)this.control.getShell(), 4);
            miColors.setMenu(menu);
        } else {
            menu = new Menu(this.control);
            this.control.setMenu(menu);
        }
        this.miConsole = new MenuItem(menu, 16);
        this.miConsole.setText(Messages.PreviewColorHandler_menu_colors_console);
        this.miConsole.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewColorHandler.this.setChoice(ColorChoice.CONSOLE);
            }
        });
        this.miGrepView = new MenuItem(menu, 16);
        this.miGrepView.setText(Messages.PreviewColorHandler_menu_colors_grepview);
        this.miGrepView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewColorHandler.this.setChoice(ColorChoice.GREP_VIEW);
            }
        });
        this.loadSettings();
        this.refresh();
    }

    private void refresh() {
        switch (this.choice) {
            case CONSOLE: {
                this.control.setBackground(this.colorRegistry.get(GrepConsoleUtil.getConsoleBackgroundColor()));
                this.control.setForeground(this.colorRegistry.get(GrepConsoleUtil.getConsoleTextColor()));
                break;
            }
            case GREP_VIEW: {
                this.control.setBackground(this.colorRegistry.get(GrepConsoleUtil.getGrepViewBackgroundColor()));
                this.control.setForeground(this.colorRegistry.get(GrepConsoleUtil.getGrepViewTextColor()));
            }
        }
        this.miConsole.setSelection(this.choice == ColorChoice.CONSOLE);
        this.miGrepView.setSelection(this.choice == ColorChoice.GREP_VIEW);
    }

    public ColorChoice getChoice() {
        return this.choice;
    }

    public void setChoice(ColorChoice choice) {
        if (choice != this.choice) {
            this.choice = choice;
            this.refresh();
            this.saveSettings();
        }
    }

    private void saveSettings() {
        Activator.getDefault().getPreferenceStore().setValue(PREF_PREVIEW_COLORS, this.choice.toString());
    }

    private void loadSettings() {
        String s = Activator.getDefault().getPreferenceStore().getString(PREF_PREVIEW_COLORS);
        if (s != null && s.length() > 0) {
            try {
                this.choice = ColorChoice.valueOf(s);
            }
            catch (IllegalArgumentException ex) {
                Activator.getDefault().log(2, "Could not read preview color configuration.", ex);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (PREF_PREVIEW_COLORS.equals(event.getProperty())) {
            this.loadSettings();
            this.refresh();
        }
    }

    public static enum ColorChoice {
        CONSOLE,
        GREP_VIEW;

    }
}

