/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.styles;

import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.util.GrepConsoleUtil;
import name.schedenig.eclipse.grepconsole.view.DefaultSizeDialog;
import name.schedenig.eclipse.grepconsole.view.styles.StylePanel;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class StyleDialog
extends DefaultSizeDialog {
    public static final String DIALOG_SETTINGS_SECTION = "styleDialog";
    private boolean add;
    private GrepStyle grepStyle;
    private StylePanel panelStyle;

    public StyleDialog(Shell parentShell, boolean add) {
        super(parentShell);
        this.add = add;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.add ? Messages.StyleDialog_title_add_style : Messages.StyleDialog_title_edit_style);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "name.schedenig.eclipse.grepconsole.edit_style");
        this.panelStyle = new StylePanel(parent, 0);
        this.panelStyle.setGrepStyle(this.grepStyle);
        this.panelStyle.setLayoutData(new GridData(4, 4, true, true));
        return this.panelStyle;
    }

    public void setGrepStyle(GrepStyle grepStyle) {
        this.grepStyle = grepStyle;
        if (this.panelStyle != null) {
            this.panelStyle.setGrepStyle(grepStyle);
        }
    }

    public GrepStyle getGrepStyle() {
        return this.grepStyle;
    }

    protected void okPressed() {
        this.panelStyle.updateGrepStyle();
        super.okPressed();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_SECTION);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return settings;
    }

    @Override
    protected Point getDefaultSize() {
        Shell shell = this.getShell();
        return new Point(GrepConsoleUtil.charsToPixelDimensions((Drawable)shell, (int)50, (int)0).x, shell.getMinimumSize().y);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        Shell shell = this.getShell();
        shell.setMinimumSize(GrepConsoleUtil.charsToPixelDimensions((Drawable)shell, (int)45, (int)0).x, shell.computeSize((int)-1, (int)-1).y);
    }
}

