/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.styles;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.view.items.StyleImageRegistry;
import name.schedenig.eclipse.grepconsole.view.styles.StyleContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class StyleLabelProvider
extends ColumnLabelProvider {
    public static final String LABEL_UNNAMED = Messages.StyleLabelProvider_unnamed;
    private StyleImageRegistry styleImageRegistry = new StyleImageRegistry();
    private ColumnViewer viewer;

    public StyleLabelProvider(ColumnViewer viewer) {
        this.viewer = viewer;
    }

    public void dispose() {
        super.dispose();
        this.styleImageRegistry.dispose();
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element == StyleContentProvider.NULL_ELEMENT) {
            return "";
        }
        String name = ((GrepStyle)element).getName();
        return name == null ? LABEL_UNNAMED : name;
    }

    public Image getImage(Object element) {
        if (element == null || element == StyleContentProvider.NULL_ELEMENT) {
            return null;
        }
        GrepStyle style = (GrepStyle)element;
        RGB foreground = style.getForeground();
        RGB background = style.getBackground();
        return this.styleImageRegistry.getColorImage(new StyleImageRegistry.RgbPair(foreground, background));
    }

    public String getToolTipText(Object element) {
        if (!(element instanceof GrepStyle)) {
            return null;
        }
        GrepExpressionRootFolder root = (GrepExpressionRootFolder)this.viewer.getInput();
        LinkedHashSet<GrepExpressionItem> items = new LinkedHashSet<GrepExpressionItem>();
        root.findStyleUses((GrepStyle)element, items);
        if (items.isEmpty()) {
            return Messages.StyleLabelProvider_this_style_is_unused;
        }
        StringBuilder sb = null;
        for (GrepExpressionItem item : items) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(", ");
            }
            String name = item.getName();
            if (name == null || name.length() == 0) {
                name = item.getGrepExpression();
            }
            sb.append(name);
        }
        return MessageFormat.format(Messages.StyleLabelProvider_used_by_0, sb);
    }
}

