/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.styles;

import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.util.GridLayoutBuilder;
import name.schedenig.eclipse.grepconsole.view.colors.ColorRegistry;
import name.schedenig.eclipse.grepconsole.view.items.PreviewColorHandler;
import name.schedenig.eclipse.grepconsole.view.styles.StyleLabelProvider;
import name.schedenig.eclipse.popupnotifications.gui.ColorPickerLine;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StylePanel
extends Composite {
    private GrepStyle grepStyle;
    private ColorRegistry colorRegistry;
    private Composite panelCheckboxes;
    private Button cbBold;
    private Button cbItalic;
    private Label labelName;
    private Text textName;
    private StyledText stPreview;
    private ColorPickerLine cpForeground;
    private ColorPickerLine cpBackground;
    private ColorPickerLine cpUnderline;
    private ColorPickerLine cpStrikethrough;
    private ColorPickerLine cpBorder;
    private SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StylePanel.this.updatePreview();
        }
    };
    private ColorPickerLine.IColorChangeListener colorChangeListener = new ColorPickerLine.IColorChangeListener(){

        public void colorChanged(ColorPickerLine source, RGB color) {
            StylePanel.this.updatePreview();
        }
    };
    private Label labelPreview;
    private Font headerFont;

    public StylePanel(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public void dispose() {
        this.colorRegistry.disposeColors();
        super.dispose();
    }

    private void init() {
        this.headerFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        this.colorRegistry = new ColorRegistry(Activator.getDefault().getColorRegistry());
        new GridLayoutBuilder(this, 3, false).apply();
        this.labelName = new Label((Composite)this, 0);
        this.labelName.setText(Messages.StylePanel_name);
        this.labelName.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.textName = new Text((Composite)this, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.panelCheckboxes = new Composite((Composite)this, 0);
        RowLayout panelCheckboxesLayout = new RowLayout();
        panelCheckboxesLayout.marginHeight = 0;
        panelCheckboxesLayout.marginWidth = 0;
        panelCheckboxesLayout.marginRight = 0;
        panelCheckboxesLayout.marginLeft = 0;
        panelCheckboxesLayout.marginBottom = 0;
        panelCheckboxesLayout.marginTop = 0;
        this.panelCheckboxes.setLayout((Layout)panelCheckboxesLayout);
        this.panelCheckboxes.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.cbBold = new Button(this.panelCheckboxes, 32);
        this.cbBold.setText(Messages.StylePanel_bold);
        this.cbBold.addSelectionListener(this.selectionListener);
        this.cbItalic = new Button(this.panelCheckboxes, 32);
        this.cbItalic.setText(Messages.StylePanel_italic);
        this.cbItalic.addSelectionListener(this.selectionListener);
        this.cpForeground = new ColorPickerLine((Composite)this);
        this.cpForeground.setText(Messages.StylePanel_foreground);
        this.cpForeground.setDialogTitle(Messages.StylePanel_title_foreground);
        this.cpForeground.addListener(this.colorChangeListener);
        this.cpBackground = new ColorPickerLine((Composite)this);
        this.cpBackground.setText(Messages.StylePanel_background);
        this.cpBackground.setDialogTitle(Messages.StylePanel_title_background);
        this.cpBackground.addListener(this.colorChangeListener);
        this.cpUnderline = new ColorPickerLine((Composite)this);
        this.cpUnderline.setText(Messages.StylePanel_underline);
        this.cpUnderline.setDialogTitle(Messages.StylePanel_title_underline);
        this.cpUnderline.setColorMandatory(false);
        this.cpUnderline.addListener(this.colorChangeListener);
        this.cpStrikethrough = new ColorPickerLine((Composite)this);
        this.cpStrikethrough.setText(Messages.StylePanel_strikethrough);
        this.cpStrikethrough.setDialogTitle(Messages.StylePanel_title_strikethrough);
        this.cpStrikethrough.setColorMandatory(false);
        this.cpStrikethrough.addListener(this.colorChangeListener);
        this.cpBorder = new ColorPickerLine((Composite)this);
        this.cpBorder.setText(Messages.StylePanel_border);
        this.cpBorder.setDialogTitle(Messages.StylePanel_title_border);
        this.cpBorder.setColorMandatory(false);
        this.cpBorder.addListener(this.colorChangeListener);
        this.labelPreview = new Label((Composite)this, 0);
        this.labelPreview.setFont(this.headerFont);
        this.labelPreview.setText(Messages.StylePanel_preview);
        GridData gridData = new GridData(4, 0x1000000, true, false, 3, 1);
        gridData.verticalIndent = 10;
        this.labelPreview.setLayoutData((Object)gridData);
        final String unstyledText = Messages.StylePanel_unstyled_preview;
        String styledText = Messages.StylePanel_styled_preview;
        this.stPreview = new StyledText((Composite)this, 2048);
        this.stPreview.setText(String.valueOf(unstyledText) + "\n" + styledText + "\n" + unstyledText);
        this.stPreview.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        this.stPreview.setFont(JFaceResources.getTextFont());
        this.stPreview.setEditable(false);
        new PreviewColorHandler((Control)this.stPreview);
        this.stPreview.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                if (event.lineOffset == unstyledText.length() + 1) {
                    StyleRange style = new StyleRange();
                    style.start = event.lineOffset;
                    style.length = event.lineText.length();
                    StylePanel.this.fillStyleRange(style);
                    event.styles = new StyleRange[]{style};
                }
            }
        });
        this.refresh();
    }

    public void refresh() {
        if (this.grepStyle == null) {
            this.textName.setText("");
            this.cbBold.setSelection(false);
            this.cbItalic.setSelection(false);
            this.cpForeground.setColor(null);
            this.cpBackground.setColor(null);
            this.cpUnderline.setColor(null);
            this.cpUnderline.setChecked(false);
            this.cpStrikethrough.setColor(null);
            this.cpStrikethrough.setChecked(false);
            this.cpBorder.setColor(null);
            this.cpBorder.setChecked(false);
        } else {
            String name = this.grepStyle.getName();
            this.textName.setText(name == null ? StyleLabelProvider.LABEL_UNNAMED : name);
            this.cbBold.setSelection(this.grepStyle.isBold());
            this.cbItalic.setSelection(this.grepStyle.isItalic());
            this.cpForeground.setColor(this.grepStyle.getForeground());
            this.cpBackground.setColor(this.grepStyle.getBackground());
            this.cpUnderline.setColor(this.grepStyle.getUnderlineColor());
            this.cpUnderline.setChecked(this.grepStyle.isUnderline());
            this.cpStrikethrough.setColor(this.grepStyle.getStrikeoutColor());
            this.cpStrikethrough.setChecked(this.grepStyle.isStrikeout());
            this.cpBorder.setColor(this.grepStyle.getBorderColor());
            this.cpBorder.setChecked(this.grepStyle.isBorder());
        }
        this.textName.selectAll();
        this.updatePreview();
    }

    protected void fillStyleRange(StyleRange style) {
        RGB rgbForeground = this.cpForeground.getEffectiveColor();
        RGB rgbBackground = this.cpBackground.getEffectiveColor();
        RGB rgbUnderline = this.cpUnderline.getEffectiveColor();
        RGB rgbStrikethrough = this.cpStrikethrough.getEffectiveColor();
        RGB rgbBorder = this.cpBorder.getEffectiveColor();
        if (rgbBackground == null) {
            rgbBackground = new RGB(255, 255, 255);
        }
        style.foreground = this.getColor(rgbForeground);
        style.background = this.getColor(rgbBackground);
        style.fontStyle = (this.cbBold.getSelection() ? 1 : 0) | (this.cbItalic.getSelection() ? 2 : 0);
        style.underline = this.cpUnderline.isChecked();
        style.underlineColor = this.getColor(rgbUnderline);
        style.strikeout = this.cpStrikethrough.isChecked();
        style.strikeoutColor = this.getColor(rgbStrikethrough);
        style.borderStyle = this.cpBorder.isChecked() ? 1 : 0;
        style.borderColor = this.getColor(rgbBorder);
    }

    private Color getColor(RGB rgb) {
        return rgb == null ? null : this.colorRegistry.get(rgb);
    }

    private void updatePreview() {
        this.colorRegistry.disposeColors();
        this.stPreview.redraw();
    }

    public void setGrepStyle(GrepStyle grepStyle) {
        this.grepStyle = grepStyle;
        if (this.textName != null) {
            this.refresh();
        }
    }

    public GrepStyle getGrepStyle() {
        return this.grepStyle;
    }

    public void updateGrepStyle() {
        this.grepStyle.setName(this.textName.getText());
        this.grepStyle.setBold(this.cbBold.getSelection());
        this.grepStyle.setItalic(this.cbItalic.getSelection());
        this.grepStyle.setForeground(this.cpForeground.getEffectiveColor());
        this.grepStyle.setBackground(this.cpBackground.getEffectiveColor());
        this.grepStyle.setUnderline(this.cpUnderline.isChecked());
        this.grepStyle.setUnderlineColor(this.cpUnderline.getColor());
        this.grepStyle.setStrikeout(this.cpStrikethrough.isChecked());
        this.grepStyle.setStrikeoutColor(this.cpStrikethrough.getColor());
        this.grepStyle.setBorder(this.cpBorder.isChecked());
        this.grepStyle.setBorderColor(this.cpBorder.getColor());
    }
}

