/*
 * Decompiled with CFR 0.152.
 */
package name.schedenig.eclipse.grepconsole.view.styles;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import name.schedenig.eclipse.grepconsole.Activator;
import name.schedenig.eclipse.grepconsole.i18n.Messages;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionItem;
import name.schedenig.eclipse.grepconsole.model.GrepExpressionRootFolder;
import name.schedenig.eclipse.grepconsole.model.GrepGroup;
import name.schedenig.eclipse.grepconsole.model.GrepStyle;
import name.schedenig.eclipse.grepconsole.util.GridLayoutBuilder;
import name.schedenig.eclipse.grepconsole.view.ReadOnlyListDialog;
import name.schedenig.eclipse.grepconsole.view.colors.ColorRegistry;
import name.schedenig.eclipse.grepconsole.view.items.ItemLabelProvider;
import name.schedenig.eclipse.grepconsole.view.items.PreviewColorHandler;
import name.schedenig.eclipse.grepconsole.view.styles.StyleComparator;
import name.schedenig.eclipse.grepconsole.view.styles.StyleContentProvider;
import name.schedenig.eclipse.grepconsole.view.styles.StyleDialog;
import name.schedenig.eclipse.grepconsole.view.styles.StyleLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class StylesPanel
extends Composite {
    private LinkedHashSet<IStylesListener> listeners = new LinkedHashSet();
    private GrepExpressionRootFolder root;
    private ColorRegistry colorRegistry;
    private Table table;
    private TableViewer viewer;
    private StyledText stPreview;
    private Button btnNew;
    private Button btnEdit;
    private Button btnDelete;
    private Composite panelButtons;

    public StylesPanel(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    protected void onDispose() {
        this.colorRegistry.disposeColors();
    }

    protected void init() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StylesPanel.this.onDispose();
            }
        });
        this.colorRegistry = new ColorRegistry(Activator.getDefault().getColorRegistry());
        new GridLayoutBuilder(this, 1, true).setMargins(0).apply();
        this.table = new Table((Composite)this, 2050);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new StyleContentProvider(false));
        this.viewer.setComparator((ViewerComparator)new StyleComparator());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StylesPanel.this.doStylesSelected(StylesPanel.this.getSelectedStyles());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StylesPanel.this.doStyleDoubleClicked(StylesPanel.this.getSelectedStyle((IStructuredSelection)event.getSelection()));
            }
        });
        TableViewerColumn colAvailableStyle = new TableViewerColumn(this.viewer, 16384);
        colAvailableStyle.getColumn().setText(Messages.StylesPanel_available_styles);
        colAvailableStyle.getColumn().setWidth(150);
        colAvailableStyle.setLabelProvider((CellLabelProvider)new StyleLabelProvider((ColumnViewer)this.viewer));
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    StylesPanel.this.doDeleteStyles();
                    e.doit = false;
                } else if (e.keyCode == 0x100000B) {
                    StylesPanel.this.doEditStyle();
                    e.doit = false;
                }
            }
        });
        this.stPreview = new StyledText((Composite)this, 2048);
        this.stPreview.setText(Messages.StylesPanel_style_preview);
        this.stPreview.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        this.stPreview.setFont(JFaceResources.getTextFont());
        new PreviewColorHandler((Control)this.stPreview);
        this.stPreview.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                GrepStyle grepStyle = StylesPanel.this.getSelectedStyle();
                if (grepStyle != null) {
                    StyleRange style = new StyleRange();
                    style.start = event.lineOffset;
                    style.length = event.lineText.length();
                    StylesPanel.this.fillStyleRange(style, grepStyle);
                    event.styles = new StyleRange[]{style};
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.panelButtons = new Composite((Composite)this, 0);
        this.panelButtons.setLayout((Layout)new FillLayout(256));
        this.panelButtons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.createButtons(this.panelButtons);
        if (this.root != null) {
            this.viewer.setInput((Object)this.root);
        }
    }

    protected void doStyleDoubleClicked(GrepStyle style) {
        boolean done = false;
        for (IStylesListener listener : this.listeners) {
            done |= listener.onStyleDoubleClicked(this, style);
        }
        if (!done) {
            this.doEditStyle(style);
        }
    }

    protected void createButtons(Composite parent) {
        this.btnNew = this.createNewButton(parent);
        this.btnEdit = this.createEditButton(parent);
        this.btnDelete = this.createDeleteButton(parent);
    }

    protected Button createNewButton(Composite parent) {
        Button btn = new Button(parent, 8);
        btn.setText(Messages.StylesPanel_new);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StylesPanel.this.doNewStyle();
            }
        });
        return btn;
    }

    protected Button createEditButton(Composite parent) {
        Button btn = new Button(parent, 8);
        btn.setText(Messages.StylesPanel_edit);
        btn.setEnabled(false);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StylesPanel.this.doEditStyle();
            }
        });
        return btn;
    }

    protected Button createDeleteButton(Composite parent) {
        Button btn = new Button(parent, 8);
        btn.setText(Messages.StylesPanel_delete);
        btn.setEnabled(false);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StylesPanel.this.doDeleteStyles();
            }
        });
        return btn;
    }

    public void addListener(IStylesListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IStylesListener listener) {
        this.listeners.remove(listener);
    }

    public void setRoot(GrepExpressionRootFolder root) {
        this.root = root;
        if (this.viewer != null) {
            this.viewer.setInput((Object)root);
        }
    }

    public void setIncludeNullStyle(boolean includeNull) {
        ((StyleContentProvider)this.viewer.getContentProvider()).setIncludeNull(includeNull);
        this.viewer.refresh();
    }

    public void doNewStyle() {
        GrepStyle newStyle = new GrepStyle();
        newStyle.setName(Messages.StylesPanel_new_style);
        StyleDialog dlg = new StyleDialog(this.getShell(), true);
        dlg.setGrepStyle(newStyle);
        if (dlg.open() == 0) {
            this.root.addStyle(newStyle);
            this.viewer.refresh();
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)newStyle));
            for (IStylesListener listener : this.listeners) {
                listener.onNewStyle(this, newStyle);
            }
        }
    }

    public void doEditStyle() {
        this.doEditStyle(this.getSelectedStyle());
    }

    public void doEditStyle(GrepStyle style) {
        if (style == null) {
            return;
        }
        StyleDialog dlg = new StyleDialog(this.getShell(), false);
        dlg.setGrepStyle(style);
        if (dlg.open() == 0) {
            this.viewer.refresh();
            this.stPreview.redraw();
            for (IStylesListener listener : this.listeners) {
                listener.onStyleChanged(this, style);
            }
        }
    }

    public void doDeleteStyles() {
        boolean doIt;
        String msg;
        String styleName;
        GrepStyle singleStyle;
        Collection<GrepStyle> styles = this.getSelectedStyles();
        if (styles.isEmpty()) {
            return;
        }
        LinkedHashSet<GrepExpressionItem> items = new LinkedHashSet<GrepExpressionItem>();
        for (GrepStyle style : styles) {
            this.root.findStyleUses(style, items);
        }
        GrepStyle grepStyle = singleStyle = styles.size() == 1 ? styles.iterator().next() : null;
        if (items.isEmpty()) {
            if (singleStyle != null) {
                styleName = singleStyle.getName();
                msg = MessageFormat.format(Messages.StylesPanel_delete_style_confirm_single, styleName == null ? Messages.StylesPanel_unnamed : styleName);
            } else {
                msg = MessageFormat.format(Messages.StylesPanel_delete_style_confirm_multi, styles.size());
            }
            doIt = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.StylesPanel_delete_style_title, (String)msg);
        } else {
            if (singleStyle != null) {
                styleName = singleStyle.getName();
                msg = MessageFormat.format(Messages.StylesPanel_delete_style_still_used_confirm_single, styleName == null ? Messages.StylesPanel_unnamed : styleName);
            } else {
                msg = MessageFormat.format(Messages.StylesPanel_delete_style_still_used_confirm_multi, styles.size());
            }
            ReadOnlyListDialog dlg = new ReadOnlyListDialog(this.getShell());
            dlg.setTitle(Messages.StylesPanel_delete_style_title);
            dlg.setMessage(msg);
            dlg.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return ((Collection)inputElement).toArray();
                }
            });
            dlg.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
            dlg.setInput(items);
            boolean bl = doIt = dlg.open() == 0;
        }
        if (!doIt) {
            return;
        }
        int index = this.viewer.getTable().getSelectionIndex();
        for (GrepStyle style : styles) {
            this.root.removeStyle(style);
            for (GrepExpressionItem item : items) {
                GrepGroup[] groups = item.getGroups();
                int i = 0;
                while (i < groups.length) {
                    if (groups[i].getStyle() == style) {
                        groups[i].setStyle(null);
                    }
                    ++i;
                }
            }
            for (IStylesListener listener : this.listeners) {
                listener.onStyleDeleted(this, style);
            }
        }
        this.viewer.refresh();
        this.viewer.getTable().select(Math.min(index, this.root.getStyles().size() - 1));
    }

    protected void doStylesSelected(Collection<GrepStyle> styles) {
        this.stPreview.redraw();
        this.btnEdit.setEnabled(styles.size() == 1);
        this.btnDelete.setEnabled(!styles.isEmpty());
        GrepStyle style = styles.size() == 1 ? styles.iterator().next() : null;
        for (IStylesListener listener : this.listeners) {
            listener.onStyleSelected(this, style);
        }
    }

    protected void fillStyleRange(StyleRange style, GrepStyle grepStyle) {
        RGB rgbForeground = grepStyle.getForeground();
        RGB rgbBackground = grepStyle.getBackground();
        RGB rgbUnderline = grepStyle.getUnderlineColor();
        RGB rgbStrikethrough = grepStyle.getStrikeoutColor();
        RGB rgbBorder = grepStyle.getBorderColor();
        if (rgbBackground == null) {
            rgbBackground = new RGB(255, 255, 255);
        }
        style.foreground = this.colorRegistry.get(rgbForeground);
        style.background = this.colorRegistry.get(rgbBackground);
        style.fontStyle = (grepStyle.isBold() ? 1 : 0) | (grepStyle.isItalic() ? 2 : 0);
        style.underline = grepStyle.isUnderline();
        style.underlineColor = this.colorRegistry.get(rgbUnderline);
        style.strikeout = grepStyle.isStrikeout();
        style.strikeoutColor = this.colorRegistry.get(rgbStrikethrough);
        style.borderStyle = grepStyle.isBorder() ? 1 : 0;
        style.borderColor = this.colorRegistry.get(rgbBorder);
    }

    public GrepStyle getSelectedStyle() {
        return this.getSelectedStyle((IStructuredSelection)this.viewer.getSelection());
    }

    public Collection<GrepStyle> getSelectedStyles() {
        LinkedList<GrepStyle> styles = new LinkedList<GrepStyle>();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection != null) {
            for (Object o : selection.toList()) {
                if (!(o instanceof GrepStyle)) continue;
                styles.add((GrepStyle)o);
            }
        }
        return styles;
    }

    protected GrepStyle getSelectedStyle(IStructuredSelection selection) {
        Object o = selection == null || selection.isEmpty() ? null : selection.getFirstElement();
        return (GrepStyle)(o instanceof GrepStyle ? o : null);
    }

    public void setSelection(GrepStyle style) {
        this.viewer.setSelection((ISelection)(style == null ? null : new StructuredSelection((Object)style)));
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public static interface IStylesListener {
        public void onNewStyle(StylesPanel var1, GrepStyle var2);

        public void onStyleDeleted(StylesPanel var1, GrepStyle var2);

        public void onStyleChanged(StylesPanel var1, GrepStyle var2);

        public void onStyleSelected(StylesPanel var1, GrepStyle var2);

        public boolean onStyleDoubleClicked(StylesPanel var1, GrepStyle var2);
    }
}

